/*
 * Decompiled with CFR 0.152.
 */
package wtf.metio.memoization.rxjava;

import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.functions.Function;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import wtf.metio.memoization.core.AbstractMemoizer;
import wtf.metio.memoization.core.WrappedThrowable;

final class ConsumerMemoizer<INPUT, KEY>
extends AbstractMemoizer<KEY, KEY>
implements Consumer<INPUT> {
    private final Function<INPUT, KEY> keyFunction;
    private final Consumer<INPUT> consumer;

    ConsumerMemoizer(ConcurrentMap<KEY, KEY> cache, Function<INPUT, KEY> keyFunction, Consumer<INPUT> consumer) {
        super(cache);
        this.keyFunction = Objects.requireNonNull(keyFunction, "Provide a key function, might just be 'Function.identity()'.");
        this.consumer = Objects.requireNonNull(consumer, "Cannot memoize a NULL Consumer - provide an actual Consumer to fix this.");
    }

    public void accept(INPUT input) throws Throwable {
        try {
            this.computeIfAbsent(this.keyFunction.apply(input), key -> {
                try {
                    this.consumer.accept(input);
                    return key;
                }
                catch (Throwable exception) {
                    throw new WrappedThrowable(exception);
                }
            });
        }
        catch (WrappedThrowable exception) {
            throw exception.wrappedThrowable();
        }
    }
}

