/*
 * Decompiled with CFR 0.152.
 */
package wtf.metio.memoization.rxjava;

import io.reactivex.rxjava3.functions.Function3;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import wtf.metio.memoization.core.AbstractMemoizer;
import wtf.metio.memoization.core.WrappedThrowable;

final class Function3Memoizer<KEY, TYPE1, TYPE2, TYPE3, OUTPUT>
extends AbstractMemoizer<KEY, OUTPUT>
implements Function3<TYPE1, TYPE2, TYPE3, OUTPUT> {
    private final Function3<TYPE1, TYPE2, TYPE3, KEY> keyFunction;
    private final Function3<TYPE1, TYPE2, TYPE3, OUTPUT> function;

    Function3Memoizer(ConcurrentMap<KEY, OUTPUT> cache, Function3<TYPE1, TYPE2, TYPE3, KEY> keyFunction, Function3<TYPE1, TYPE2, TYPE3, OUTPUT> function) {
        super(cache);
        this.keyFunction = Objects.requireNonNull(keyFunction, "Provide a key function.");
        this.function = Objects.requireNonNull(function, "Cannot memoize a NULL Function3 - provide an actual Function3 to fix this.");
    }

    public OUTPUT apply(TYPE1 v1, TYPE2 v2, TYPE3 v3) throws Throwable {
        try {
            return (OUTPUT)this.computeIfAbsent(this.keyFunction.apply(v1, v2, v3), key -> {
                try {
                    return this.function.apply(v1, v2, v3);
                }
                catch (Throwable exception) {
                    throw new WrappedThrowable(exception);
                }
            });
        }
        catch (WrappedThrowable exception) {
            throw exception.wrappedThrowable();
        }
    }
}

