/*
 * Decompiled with CFR 0.152.
 */
package wtf.metio.memoization.rxjava;

import io.reactivex.rxjava3.functions.Function5;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import wtf.metio.memoization.core.AbstractMemoizer;
import wtf.metio.memoization.core.WrappedThrowable;

final class Function5Memoizer<KEY, TYPE1, TYPE2, TYPE3, TYPE4, TYPE5, OUTPUT>
extends AbstractMemoizer<KEY, OUTPUT>
implements Function5<TYPE1, TYPE2, TYPE3, TYPE4, TYPE5, OUTPUT> {
    private final Function5<TYPE1, TYPE2, TYPE3, TYPE4, TYPE5, KEY> keyFunction;
    private final Function5<TYPE1, TYPE2, TYPE3, TYPE4, TYPE5, OUTPUT> function;

    Function5Memoizer(ConcurrentMap<KEY, OUTPUT> cache, Function5<TYPE1, TYPE2, TYPE3, TYPE4, TYPE5, KEY> keyFunction, Function5<TYPE1, TYPE2, TYPE3, TYPE4, TYPE5, OUTPUT> function) {
        super(cache);
        this.keyFunction = Objects.requireNonNull(keyFunction, "Provide a key function.");
        this.function = Objects.requireNonNull(function, "Cannot memoize a NULL Function5 - provide an actual Function5 to fix this.");
    }

    public OUTPUT apply(TYPE1 v1, TYPE2 v2, TYPE3 v3, TYPE4 v4, TYPE5 v5) throws Throwable {
        try {
            return (OUTPUT)this.computeIfAbsent(this.keyFunction.apply(v1, v2, v3, v4, v5), key -> {
                try {
                    return this.function.apply(v1, v2, v3, v4, v5);
                }
                catch (Throwable exception) {
                    throw new WrappedThrowable(exception);
                }
            });
        }
        catch (WrappedThrowable exception) {
            throw exception.wrappedThrowable();
        }
    }
}

