/*
 * Decompiled with CFR 0.152.
 */
package wtf.metio.memoization.rxjava;

import io.reactivex.rxjava3.functions.Function7;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import wtf.metio.memoization.core.AbstractMemoizer;
import wtf.metio.memoization.core.WrappedThrowable;

final class Function7Memoizer<KEY, TYPE1, TYPE2, TYPE3, TYPE4, TYPE5, TYPE6, TYPE7, OUTPUT>
extends AbstractMemoizer<KEY, OUTPUT>
implements Function7<TYPE1, TYPE2, TYPE3, TYPE4, TYPE5, TYPE6, TYPE7, OUTPUT> {
    private final Function7<TYPE1, TYPE2, TYPE3, TYPE4, TYPE5, TYPE6, TYPE7, KEY> keyFunction;
    private final Function7<TYPE1, TYPE2, TYPE3, TYPE4, TYPE5, TYPE6, TYPE7, OUTPUT> function;

    Function7Memoizer(ConcurrentMap<KEY, OUTPUT> cache, Function7<TYPE1, TYPE2, TYPE3, TYPE4, TYPE5, TYPE6, TYPE7, KEY> keyFunction, Function7<TYPE1, TYPE2, TYPE3, TYPE4, TYPE5, TYPE6, TYPE7, OUTPUT> function) {
        super(cache);
        this.keyFunction = Objects.requireNonNull(keyFunction, "Provide a key function.");
        this.function = Objects.requireNonNull(function, "Cannot memoize a NULL Function7 - provide an actual Function7 to fix this.");
    }

    public OUTPUT apply(TYPE1 v1, TYPE2 v2, TYPE3 v3, TYPE4 v4, TYPE5 v5, TYPE6 v6, TYPE7 v7) throws Throwable {
        try {
            return (OUTPUT)this.computeIfAbsent(this.keyFunction.apply(v1, v2, v3, v4, v5, v6, v7), key -> {
                try {
                    return this.function.apply(v1, v2, v3, v4, v5, v6, v7);
                }
                catch (Throwable exception) {
                    throw new WrappedThrowable(exception);
                }
            });
        }
        catch (WrappedThrowable exception) {
            throw exception.wrappedThrowable();
        }
    }
}

