/*
 * Decompiled with CFR 0.152.
 */
package wtf.metio.memoization.rxjava;

import io.reactivex.rxjava3.functions.Function;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import wtf.metio.memoization.core.AbstractMemoizer;
import wtf.metio.memoization.core.WrappedThrowable;

final class FunctionMemoizer<INPUT, KEY, OUTPUT>
extends AbstractMemoizer<KEY, OUTPUT>
implements Function<INPUT, OUTPUT> {
    private final Function<INPUT, KEY> keyFunction;
    private final Function<INPUT, OUTPUT> function;

    FunctionMemoizer(ConcurrentMap<KEY, OUTPUT> cache, Function<INPUT, KEY> keyFunction, Function<INPUT, OUTPUT> function) {
        super(cache);
        this.keyFunction = Objects.requireNonNull(keyFunction, "Provide a key function.");
        this.function = Objects.requireNonNull(function, "Cannot memoize a NULL Function - provide an actual Function to fix this.");
    }

    public OUTPUT apply(INPUT input) throws Throwable {
        try {
            return (OUTPUT)this.computeIfAbsent(this.keyFunction.apply(input), key -> {
                try {
                    return this.function.apply(input);
                }
                catch (Throwable exception) {
                    throw new WrappedThrowable(exception);
                }
            });
        }
        catch (WrappedThrowable exception) {
            throw exception.wrappedThrowable();
        }
    }
}

