/*
 * Decompiled with CFR 0.152.
 */
package wtf.metio.memoization.rxjava;

import io.reactivex.rxjava3.functions.IntFunction;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import wtf.metio.memoization.core.AbstractMemoizer;
import wtf.metio.memoization.core.WrappedThrowable;

final class IntFunctionMemoizer<KEY, OUTPUT>
extends AbstractMemoizer<KEY, OUTPUT>
implements IntFunction<OUTPUT> {
    private final IntFunction<KEY> keyFunction;
    private final IntFunction<OUTPUT> function;

    IntFunctionMemoizer(ConcurrentMap<KEY, OUTPUT> cache, IntFunction<KEY> keyFunction, IntFunction<OUTPUT> function) {
        super(cache);
        this.keyFunction = Objects.requireNonNull(keyFunction, "Provide a key function.");
        this.function = Objects.requireNonNull(function, "Cannot memoize a NULL IntFunction - provide an actual IntFunction to fix this.");
    }

    public OUTPUT apply(int number) throws Throwable {
        try {
            return (OUTPUT)this.computeIfAbsent(this.keyFunction.apply(number), key -> {
                try {
                    return this.function.apply(number);
                }
                catch (Throwable exception) {
                    throw new WrappedThrowable(exception);
                }
            });
        }
        catch (WrappedThrowable exception) {
            throw exception.wrappedThrowable();
        }
    }
}

