/*
 * Decompiled with CFR 0.152.
 */
package wtf.metio.memoization.rxjava;

import io.reactivex.rxjava3.functions.LongConsumer;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.function.LongFunction;
import wtf.metio.memoization.core.AbstractMemoizer;
import wtf.metio.memoization.core.WrappedThrowable;

final class LongConsumerMemoizer<KEY>
extends AbstractMemoizer<KEY, KEY>
implements LongConsumer {
    private final LongFunction<KEY> keyFunction;
    private final LongConsumer consumer;

    LongConsumerMemoizer(ConcurrentMap<KEY, KEY> cache, LongFunction<KEY> keyFunction, LongConsumer consumer) {
        super(cache);
        this.keyFunction = Objects.requireNonNull(keyFunction, "Provide a key function.");
        this.consumer = Objects.requireNonNull(consumer, "Cannot memoize a NULL LongConsumer - provide an actual LongConsumer to fix this.");
    }

    public void accept(long value) throws Throwable {
        try {
            this.computeIfAbsent(this.keyFunction.apply(value), key -> {
                try {
                    this.consumer.accept(value);
                    return key;
                }
                catch (Throwable exception) {
                    throw new WrappedThrowable(exception);
                }
            });
        }
        catch (WrappedThrowable exception) {
            throw exception.wrappedThrowable();
        }
    }
}

