/*
 * Decompiled with CFR 0.152.
 */
package wtf.metio.memoization.rxjava;

import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.functions.Predicate;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import wtf.metio.memoization.core.AbstractMemoizer;
import wtf.metio.memoization.core.WrappedThrowable;

final class PredicateMemoizer<INPUT, KEY>
extends AbstractMemoizer<KEY, Boolean>
implements Predicate<INPUT> {
    private final Function<INPUT, KEY> keyFunction;
    private final Predicate<INPUT> predicate;

    PredicateMemoizer(ConcurrentMap<KEY, Boolean> cache, Function<INPUT, KEY> keyFunction, Predicate<INPUT> predicate) {
        super(cache);
        this.keyFunction = Objects.requireNonNull(keyFunction, "Provide a key function.");
        this.predicate = Objects.requireNonNull(predicate, "Cannot memoize a NULL Predicate - provide an actual Predicate to fix this.");
    }

    public boolean test(INPUT input) throws Throwable {
        try {
            return (Boolean)this.computeIfAbsent(this.keyFunction.apply(input), key -> {
                try {
                    return this.predicate.test(input);
                }
                catch (Throwable exception) {
                    throw new WrappedThrowable(exception);
                }
            });
        }
        catch (WrappedThrowable exception) {
            throw exception.wrappedThrowable();
        }
    }
}

