/*
 * Decompiled with CFR 0.152.
 */
package wtf.metio.memoization.rxjava;

import io.reactivex.rxjava3.functions.Supplier;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import wtf.metio.memoization.core.AbstractMemoizer;
import wtf.metio.memoization.core.WrappedThrowable;

final class SupplierMemoizer<KEY, VALUE>
extends AbstractMemoizer<KEY, VALUE>
implements Supplier<VALUE> {
    private final Supplier<KEY> keySupplier;
    private final Supplier<VALUE> supplier;

    SupplierMemoizer(ConcurrentMap<KEY, VALUE> cache, Supplier<KEY> keySupplier, Supplier<VALUE> supplier) {
        super(cache);
        this.keySupplier = Objects.requireNonNull(keySupplier, "Provide a key supplier.");
        this.supplier = Objects.requireNonNull(supplier, "Cannot memoize a NULL Supplier - provide an actual Supplier to fix this.");
    }

    public VALUE get() throws Throwable {
        try {
            return (VALUE)this.computeIfAbsent(this.keySupplier.get(), key -> {
                try {
                    return this.supplier.get();
                }
                catch (Throwable exception) {
                    throw new WrappedThrowable(exception);
                }
            });
        }
        catch (WrappedThrowable exception) {
            throw exception.wrappedThrowable();
        }
    }
}

