/*
 * Decompiled with CFR 0.152.
 */
package xin.bluesky.leiothrix.worker;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xin.bluesky.leiothrix.common.jdbc.JdbcTemplate;
import xin.bluesky.leiothrix.worker.background.ResourceMonitor;
import xin.bluesky.leiothrix.worker.background.ShutdownHook;
import xin.bluesky.leiothrix.worker.client.ServerChannel;
import xin.bluesky.leiothrix.worker.conf.SettingInit;
import xin.bluesky.leiothrix.worker.conf.Settings;
import xin.bluesky.leiothrix.worker.conf.WorkerConfiguration;
import xin.bluesky.leiothrix.worker.executor.ExecutorsPool;
import xin.bluesky.leiothrix.worker.executor.ProcessorAnnouncer;
import xin.bluesky.leiothrix.worker.executor.TaskExecutor;
import xin.bluesky.leiothrix.worker.report.WorkerProgressReporter;

public class WorkerProcessor {
    private static final Logger logger = LoggerFactory.getLogger(WorkerProcessor.class);
    private static WorkerProcessor processor;
    private ExecutorsPool executorsPool;
    private WorkerProgressReporter progressReporter;
    private ResourceMonitor resourceMonitor;
    private volatile Status status;
    private ReentrantLock lock = new ReentrantLock();
    private CountDownLatch countDownLatch;
    private WorkerConfiguration configuration;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkerProcessor(WorkerConfiguration configuration) {
        Class<WorkerProcessor> clazz = WorkerProcessor.class;
        synchronized (WorkerProcessor.class) {
            if (processor != null) {
                throw new RuntimeException("\u5df2\u7ecf\u521b\u5efa\u4e86\u4e00\u4e2aworker\u8fdb\u7a0b,\u4e0d\u80fd\u91cd\u590d\u521b\u5efa");
            }
            processor = this;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.configuration = configuration;
            this.progressReporter = new WorkerProgressReporter();
            this.resourceMonitor = new ResourceMonitor();
            this.status = Status.NOT_STARTED;
            return;
        }
    }

    private void beforeStart() {
        SettingInit.init(this.configuration);
        this.executorsPool = new ExecutorsPool();
        this.countDownLatch = new CountDownLatch(this.executorsPool.getPoolSize());
    }

    public void start() {
        this.beforeStart();
        try {
            this.lock.lock();
            if (this.status != Status.NOT_STARTED) {
                this.lock.unlock();
                throw new Exception("worker\u8fdb\u7a0b\u5df2\u7ecf\u542f\u52a8/\u6216\u5df2\u5173\u95ed,\u4e0d\u80fd\u518d\u6b21\u542f\u52a8");
            }
            logger.info("worker\u8fdb\u7a0b\u5f00\u59cb\u542f\u52a8");
            this.status = Status.RUNNING;
            this.lock.unlock();
            ServerChannel.connect(Settings.getServersIp(), Settings.getServerPort());
            Runtime.getRuntime().addShutdownHook(new ShutdownHook());
            this.submitExecutor();
            this.progressReporter.start();
            this.resourceMonitor.start();
            ProcessorAnnouncer.announceStartupSuccess();
            this.awaitTermination();
        }
        catch (Throwable e) {
            logger.error("worker\u542f\u52a8\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u5f02\u5e38:{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            ProcessorAnnouncer.announceStartupFail(StringEscapeUtils.escapeJava((String)ExceptionUtils.getStackTrace((Throwable)e)));
        }
        finally {
            this.shutdown();
        }
    }

    private void submitExecutor() {
        for (int i = 0; i < this.executorsPool.getPoolSize(); ++i) {
            this.executorsPool.submit(new TaskExecutor(this.progressReporter, this.countDownLatch));
        }
    }

    public void awaitTermination() throws InterruptedException {
        this.countDownLatch.await();
        logger.info("\u6240\u6709\u5de5\u4f5c\u7ebf\u7a0b\u90fd\u5df2\u7ed3\u675f");
    }

    public boolean isRunning() {
        return this.status == Status.RUNNING;
    }

    public boolean reducePressure() {
        int size = this.executorsPool.getRemainingExecutorSize();
        if (size == 1) {
            logger.info("\u5f53\u524d\u53ea\u67091\u4e2a\u5de5\u4f5c\u7ebf\u7a0b\u5728\u6267\u884c,\u4e0d\u518d\u964d\u538b");
            return false;
        }
        int reduceSize = size / 5 == 0 ? 1 : size / 5;
        this.executorsPool.rescheduleExecutor(reduceSize);
        logger.info("\u672c\u6b21\u505c\u6b62{}\u4e2a\u5de5\u4f5c\u7ebf\u7a0b\u4ee5\u964d\u4f4e\u538b\u529b,\u964d\u538b\u540e\u6709{}\u4e2a\u5de5\u4f5c\u7ebf\u7a0b", (Object)reduceSize, (Object)(size - reduceSize));
        return true;
    }

    public void shutdown() {
        this.lock.lock();
        if (!this.isRunning()) {
            this.lock.unlock();
            return;
        }
        this.status = Status.SHUTDOWN;
        this.lock.unlock();
        logger.info("\u5f00\u59cb\u9000\u51faworker\u8fdb\u7a0b");
        this.status = Status.SHUTDOWN;
        try {
            this.executorsPool.shutdown();
            this.progressReporter.shutdown();
            JdbcTemplate.destroy();
            Thread.sleep(3000L);
            logger.info("worker\u8fdb\u7a0b\u6210\u529f\u9000\u51fa");
            ProcessorAnnouncer.announceExit();
        }
        catch (Throwable e) {
            String errorMsg = StringEscapeUtils.escapeJava((String)ExceptionUtils.getStackTrace((Throwable)e));
            ProcessorAnnouncer.announceExit(errorMsg);
        }
        finally {
            try {
                ServerChannel.shutdown();
            }
            catch (InterruptedException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public Status getStatus() {
        return this.status;
    }

    public static WorkerProcessor getProcessor() {
        return processor;
    }

    static {
        Thread.setDefaultUncaughtExceptionHandler((t, e) -> logger.error("\u7ebf\u7a0b[id={},name={}]\u51fa\u73b0\u5f02\u5e38:{}", new Object[]{t.getId(), t.getName(), ExceptionUtils.getStackTrace((Throwable)e)}));
    }

    public static enum Status {
        NOT_STARTED,
        RUNNING,
        SHUTDOWN;

    }
}

