/*
 * Decompiled with CFR 0.152.
 */
package xin.bluesky.leiothrix.worker.background;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.math.BigDecimal;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xin.bluesky.leiothrix.common.util.PhysicalUtils;
import xin.bluesky.leiothrix.worker.WorkerProcessor;

public class ResourceMonitor
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(ResourceMonitor.class);
    private static ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("resource-monitor").build());
    private static int MONITOR_INTERVAL = 5;
    private static String CPU_WARN_THRESHOLD = "90";
    private static int CPU_OVERLOAD_TIMES_THRESHOLD = 3;
    private static int OLD_GC_OVERLOAD_TIMES_THRESHOLD = 2;
    private int cpuWarnCount = 0;
    private int gcWarnCount = 0;
    private long lastOldGcTimes = 0L;
    private int waitTimeAfterReducePressure = 30;
    private boolean monitor = true;

    public void start() {
        executor.scheduleWithFixedDelay(this, 30L, MONITOR_INTERVAL, TimeUnit.SECONDS);
    }

    @Override
    public void run() {
        if (!this.monitor) {
            return;
        }
        BigDecimal cpuLoad = PhysicalUtils.getCpuLoad().multiply(new BigDecimal(100)).setScale(2, 5);
        logger.debug("\u5f53\u524dCPU Load:{}", (Object)cpuLoad.doubleValue());
        this.cpuWarnCount = cpuLoad.compareTo(new BigDecimal(CPU_WARN_THRESHOLD)) > 0 ? ++this.cpuWarnCount : 0;
        if (this.cpuWarnCount >= CPU_OVERLOAD_TIMES_THRESHOLD) {
            logger.warn("CPU Load\u5df2\u7ecf\u8fde\u7eed{}\u6b21(\u6bcf\u6b21\u95f4\u9694{}\u79d2)\u8d85\u8fc7\u4e86\u8b66\u6212\u503c[{}],\u9700\u8981\u964d\u4f4e\u538b\u529b", new Object[]{CPU_OVERLOAD_TIMES_THRESHOLD, MONITOR_INTERVAL, CPU_WARN_THRESHOLD});
            this.reducePressure();
            this.cpuWarnCount = 0;
            return;
        }
        long oldGcTimes = PhysicalUtils.getOldGcTimes();
        if (this.lastOldGcTimes == 0L) {
            this.lastOldGcTimes = oldGcTimes;
            logger.debug("\u5f53\u524dOld GC\u6b21\u6570\u4e3a{}", (Object)oldGcTimes);
            return;
        }
        logger.debug("\u5f53\u524dOld GC\u6b21\u6570\u4e3a{}", (Object)oldGcTimes);
        this.gcWarnCount = oldGcTimes - this.lastOldGcTimes >= 1L ? ++this.gcWarnCount : 0;
        this.lastOldGcTimes = oldGcTimes;
        if (this.gcWarnCount >= 2) {
            logger.warn("\u5df2\u7ecf\u8fde\u7eed{}\u6b21(\u6bcf\u6b21\u95f4\u9694{}\u79d2)\u53d1\u751f\u4e86Old GC,\u9700\u8981\u964d\u4f4e\u538b\u529b", (Object)OLD_GC_OVERLOAD_TIMES_THRESHOLD, (Object)MONITOR_INTERVAL);
            this.reducePressure();
            this.gcWarnCount = 0;
            return;
        }
    }

    private void reducePressure() {
        boolean result = WorkerProcessor.getProcessor().reducePressure();
        if (!result) {
            this.monitor = false;
        }
        try {
            Thread.sleep(this.waitTimeAfterReducePressure * 1000);
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public int getCpuWarnCount() {
        return this.cpuWarnCount;
    }

    public int getGcWarnCount() {
        return this.gcWarnCount;
    }

    public boolean isMonitor() {
        return this.monitor;
    }

    public void setWaitTimeAfterReducePressure(int waitTimeAfterReducePressure) {
        this.waitTimeAfterReducePressure = waitTimeAfterReducePressure;
    }
}

