/*
 * Decompiled with CFR 0.152.
 */
package xin.bluesky.leiothrix.worker.client;

import com.alibaba.fastjson.JSON;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.pool.AbstractChannelPoolHandler;
import io.netty.channel.pool.ChannelPoolHandler;
import io.netty.channel.pool.SimpleChannelPool;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.LineBasedFrameDecoder;
import io.netty.handler.codec.string.StringDecoder;
import io.netty.handler.codec.string.StringEncoder;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xin.bluesky.leiothrix.common.util.CollectionsUtils2;
import xin.bluesky.leiothrix.worker.client.ChannelPool;
import xin.bluesky.leiothrix.worker.client.ChannelStatus;
import xin.bluesky.leiothrix.worker.msghandler.ServerChannelInboundHandler;

public class ServerChannel {
    private static final Logger logger = LoggerFactory.getLogger(ServerChannel.class);
    private static EventLoopGroup workerGroup = new NioEventLoopGroup();
    private static List<ChannelPool> poolList = new ArrayList<ChannelPool>();
    private static final Bootstrap bootstrap = new Bootstrap();
    private static int serverPort;

    private ServerChannel() {
    }

    public static void connect(String[] serversIp, int port) {
        serverPort = port;
        ((Bootstrap)((Bootstrap)bootstrap.group(workerGroup)).channel(NioSocketChannel.class)).option(ChannelOption.SO_KEEPALIVE, (Object)true);
        Arrays.asList(serversIp).forEach(ip -> {
            InetSocketAddress addr = new InetSocketAddress((String)ip, port);
            poolList.add(new ChannelPool((String)ip, new SimpleChannelPool(bootstrap.remoteAddress((SocketAddress)addr), (ChannelPoolHandler)new ServerChannelPoolHandler())));
        });
        logger.info("\u521b\u5efanetty\u8fde\u63a5\u6c60,server\u4e3a:{}", (Object)CollectionsUtils2.toString((Object[])serversIp));
    }

    private static void addServer(String ip, int port) {
        InetSocketAddress addr = new InetSocketAddress(ip, port);
        for (ChannelPool cp : poolList) {
            if (!cp.getIp().equals(ip)) continue;
            if (cp.getChannelStatus() == ChannelStatus.NORMAL) {
                return;
            }
            if (cp.getChannelStatus() != ChannelStatus.BROKEN) continue;
            cp = new ChannelPool(ip, new SimpleChannelPool(bootstrap.remoteAddress((SocketAddress)addr), (ChannelPoolHandler)new ServerChannelPoolHandler()));
            logger.info("\u589e\u52a0\u65b0\u7684server:{}", (Object)ip);
            return;
        }
        poolList.add(new ChannelPool(ip, new SimpleChannelPool(bootstrap.remoteAddress((SocketAddress)addr), (ChannelPoolHandler)new ServerChannelPoolHandler())));
        logger.info("\u589e\u52a0\u65b0\u7684server:{}", (Object)ip);
    }

    public static void send(Object message) {
        String body = JSON.toJSONString((Object)message);
        ServerChannel.send(body, 0);
    }

    private static void send(final String body, final int channelIndex) {
        if (channelIndex == poolList.size()) {
            return;
        }
        final ChannelPool cp = poolList.get(channelIndex);
        if (cp.getChannelStatus() == ChannelStatus.BROKEN) {
            ServerChannel.send(body, channelIndex + 1);
        }
        final SimpleChannelPool sp = cp.getChannelPool();
        sp.acquire().addListener((GenericFutureListener)new FutureListener<Channel>(){

            public void operationComplete(Future<Channel> future) throws Exception {
                if (future.isSuccess()) {
                    Channel ch = (Channel)future.getNow();
                    ch.writeAndFlush((Object)(body + "\r\n"));
                    sp.release(ch);
                } else {
                    if (channelIndex == poolList.size() - 1) {
                        logger.error("\u53d1\u9001\u6d88\u606f[{}]\u7ed9\u6240\u6709server[{}]\u90fd\u5931\u8d25,\u5f02\u5e38\u4e3a:{}", new Object[]{body, CollectionsUtils2.toString((Collection)poolList), ExceptionUtils.getStackTrace((Throwable)future.cause())});
                    } else {
                        logger.warn("\u53d1\u9001\u6d88\u606f[{}]\u7ed9server[{}]\u5931\u8d25,\u5f02\u5e38\u4e3a:{}", new Object[]{body, cp.getIp(), ExceptionUtils.getStackTrace((Throwable)future.cause())});
                    }
                    sp.close();
                    cp.setChannelStatus(ChannelStatus.BROKEN);
                    ServerChannel.send(body, channelIndex + 1);
                }
            }
        });
    }

    public static void serverChanged(List<String> allServers) {
        allServers.forEach(newIp -> ServerChannel.addServer(newIp, serverPort));
    }

    public static void shutdown() throws InterruptedException {
        if (!CollectionsUtils2.isEmpty(poolList)) {
            poolList.forEach(pool -> pool.getChannelPool().close());
        }
        if (workerGroup != null) {
            workerGroup.shutdownGracefully();
        }
        logger.info("\u5173\u95ed\u4e0eserver\u901a\u4fe1\u7684client\u7ebf\u7a0b");
    }

    public static class ServerChannelPoolHandler
    extends AbstractChannelPoolHandler {
        public void channelCreated(Channel ch) throws Exception {
            ch.pipeline().addLast(new ChannelHandler[]{new LineBasedFrameDecoder(2048)}).addLast("encoder", (ChannelHandler)new StringEncoder()).addLast("decoder", (ChannelHandler)new StringDecoder()).addLast("handler", (ChannelHandler)new ServerChannelInboundHandler());
        }
    }
}

