/*
 * Decompiled with CFR 0.152.
 */
package xin.bluesky.leiothrix.worker.executor;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.lang.management.ManagementFactory;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xin.bluesky.leiothrix.worker.conf.Settings;
import xin.bluesky.leiothrix.worker.executor.TaskExecutor;

public class ExecutorsPool {
    private static final Logger logger = LoggerFactory.getLogger(ExecutorsPool.class);
    private ThreadPoolExecutor executors;
    private List<TaskExecutor> reference = new ArrayList<TaskExecutor>();

    public ExecutorsPool() {
        int executorNumber = this.calExecutorsNumbers();
        this.executors = (ThreadPoolExecutor)Executors.newFixedThreadPool(executorNumber, new ThreadFactoryBuilder().setNameFormat("partition-task-runner-%d").build());
        logger.info("\u521b\u5efa\u5de5\u4f5c\u7ebf\u7a0b\u6c60,\u7ebf\u7a0b\u6570\u91cf\u4e3a:{}", (Object)executorNumber);
    }

    protected int calExecutorsNumbers() {
        int workerHeapSize;
        int cpuNumbers = Runtime.getRuntime().availableProcessors();
        long freeMemory = Runtime.getRuntime().freeMemory();
        int maxWorkerProcessNum = (int)(freeMemory >> 20) / (workerHeapSize = (int)ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getMax() >> 20);
        if (maxWorkerProcessNum == 0) {
            maxWorkerProcessNum = 1;
        }
        BigDecimal roughCpuNumbersForMe = new BigDecimal(cpuNumbers / maxWorkerProcessNum).setScale(1, 5);
        return roughCpuNumbersForMe.multiply(new BigDecimal(Settings.getThreadNumFactor())).intValue();
    }

    public void submit(TaskExecutor taskExecutor) {
        this.reference.add(taskExecutor);
        this.executors.submit(taskExecutor);
    }

    public int getPoolSize() {
        return this.executors.getCorePoolSize();
    }

    public int getRemainingExecutorSize() {
        Iterator<TaskExecutor> iterator = this.reference.iterator();
        while (iterator.hasNext()) {
            TaskExecutor te = iterator.next();
            if (!te.isFree()) continue;
            iterator.remove();
        }
        return this.reference.size();
    }

    public void rescheduleExecutor(int num) {
        if (num > this.reference.size()) {
            throw new IllegalArgumentException("stop\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7\u4efb\u52a1\u7684\u6267\u884c\u7ebf\u7a0b\u6570");
        }
        for (int i = 0; i < num; ++i) {
            TaskExecutor te = this.reference.get(0);
            te.reschedule();
            this.reference.remove(te);
        }
    }

    public void shutdown() {
        this.executors.shutdown();
        this.waitTerminated();
        logger.info("\u6210\u529f\u5173\u95ed\u5de5\u4f5c\u7ebf\u7a0b\u6c60");
    }

    private void waitTerminated() {
        while (!this.executors.isTerminated()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                logger.error("\u5de5\u4f5c\u7ebf\u7a0b\u6c60\u7ebf\u7a0b\u5728\u5173\u95ed\u7684\u65f6\u5019\u88ab\u4e2d\u65ad");
            }
        }
    }
}

