/*
 * Decompiled with CFR 0.152.
 */
package xin.bluesky.leiothrix.worker.executor;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorsPoolTry {
    private static final Logger logger = LoggerFactory.getLogger(ExecutorsPoolTry.class);
    private ThreadPoolExecutor executors;

    public ExecutorsPoolTry() {
        int executorNumber = this.calExecutorsNumbers();
        this.executors = (ThreadPoolExecutor)Executors.newFixedThreadPool(executorNumber, new ThreadFactoryBuilder().setNameFormat("partition-task-runner-%d").build());
        logger.info("\u521b\u5efa\u5de5\u4f5c\u7ebf\u7a0b\u6c60,\u7ebf\u7a0b\u6570\u91cf\u4e3a:{}", (Object)executorNumber);
    }

    protected int calExecutorsNumbers() {
        return 3;
    }

    public void submit(Task taskExecutor) {
        this.executors.submit(taskExecutor);
    }

    public int getPoolSize() {
        return this.executors.getCorePoolSize();
    }

    public void awaitTermination() {
        try {
            while (this.executors.getActiveCount() != 0) {
                Thread.sleep(5000L);
            }
            Thread.sleep(3000L);
            if (this.executors.getActiveCount() == 0) {
                logger.info("\u6240\u6709\u5de5\u4f5c\u7ebf\u7a0b\u90fd\u786e\u8ba4\u7ed3\u675f");
            }
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void shutdown() {
        this.executors.shutdown();
        this.waitTerminated();
        logger.info("\u6210\u529f\u5173\u95ed\u5de5\u4f5c\u7ebf\u7a0b\u6c60");
    }

    private void waitTerminated() {
        while (!this.executors.isTerminated()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                logger.error("\u5de5\u4f5c\u7ebf\u7a0b\u6c60\u7ebf\u7a0b\u5728\u5173\u95ed\u7684\u65f6\u5019\u88ab\u4e2d\u65ad");
            }
        }
    }

    public static void main(String[] args) throws Exception {
        ExecutorsPoolTry poolTry = new ExecutorsPoolTry();
        poolTry.submit(new Task());
        for (int i = 0; i < 20; ++i) {
            System.out.println(poolTry.executors.getActiveCount());
            Thread.sleep(1000L);
        }
    }

    private static class Task
    implements Callable {
        private Task() {
        }

        public Boolean call() throws Exception {
            Thread.sleep(3000L);
            return true;
        }
    }
}

