/*
 * Decompiled with CFR 0.152.
 */
package xin.bluesky.leiothrix.worker.executor;

import com.alibaba.fastjson.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xin.bluesky.leiothrix.common.util.PhysicalUtils;
import xin.bluesky.leiothrix.model.msg.WorkerMessage;
import xin.bluesky.leiothrix.model.stat.ProcessorInfo;
import xin.bluesky.leiothrix.worker.client.ServerChannel;
import xin.bluesky.leiothrix.worker.conf.Settings;

public class ProcessorAnnouncer {
    public static final Logger logger = LoggerFactory.getLogger(ProcessorAnnouncer.class);
    private static int counter = 0;

    public static synchronized void announceStartupSuccess() {
        ProcessorAnnouncer.startup(true, null);
    }

    public static synchronized void announceStartupFail(String errorMsg) {
        ProcessorAnnouncer.startup(false, errorMsg);
    }

    private static synchronized void startup(boolean success, String errorMsg) {
        if (counter == 0) {
            ProcessorInfo processInfo = ProcessorAnnouncer.getStaticProcessInfo();
            processInfo.setStep("startUp");
            processInfo.setSuccess(success);
            processInfo.setErrorMsg(errorMsg);
            WorkerMessage message = new WorkerMessage("processorAnnounce", JSON.toJSONString((Object)processInfo), Settings.getWorkerIp());
            ServerChannel.send(message);
            logger.info("\u5411server\u5ba3\u544a\u8fdb\u7a0b\u542f\u52a8");
            ++counter;
        }
    }

    public static synchronized void announceExit() {
        ProcessorAnnouncer.announceExit(null);
    }

    public static synchronized void announceExit(String errorMsg) {
        if (counter == 1) {
            ProcessorInfo processInfo = ProcessorAnnouncer.getStaticProcessInfo();
            processInfo.setStep("exit");
            processInfo.setSuccess(true);
            processInfo.setErrorMsg(errorMsg);
            WorkerMessage message = new WorkerMessage("processorAnnounce", JSON.toJSONString((Object)processInfo), Settings.getWorkerIp());
            ServerChannel.send(message);
            logger.info("\u5411server\u5ba3\u544a\u8fdb\u7a0b\u7ed3\u675f");
            --counter;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected static ProcessorInfo getStaticProcessInfo() {
        String processorId = PhysicalUtils.getPid();
        ProcessorInfo info = new ProcessorInfo(Settings.getTaskId(), Settings.getWorkerIp(), processorId);
        return info;
    }
}

