/*
 * Decompiled with CFR 0.152.
 */
package xin.bluesky.leiothrix.worker.executor;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xin.bluesky.leiothrix.model.msg.WorkerMessage;
import xin.bluesky.leiothrix.model.task.partition.PartitionTaskWrapper;
import xin.bluesky.leiothrix.worker.client.ServerChannel;
import xin.bluesky.leiothrix.worker.conf.Settings;

public class TaskContainer {
    private static final Logger logger = LoggerFactory.getLogger(TaskContainer.class);
    private static TaskContainer instance = new TaskContainer();
    private BlockingQueue<PartitionTaskWrapper> partitionTaskBlockingQueue = new LinkedBlockingQueue<PartitionTaskWrapper>();

    private TaskContainer() {
    }

    public static PartitionTaskWrapper takePartitionTaskWrapper(long timeout, TimeUnit timeUnit) throws InterruptedException {
        ServerChannel.send(new WorkerMessage("acquireTask", Settings.getTaskId(), Settings.getWorkerIp()));
        return TaskContainer.instance.partitionTaskBlockingQueue.poll(timeout, timeUnit);
    }

    public static void putPartitionTaskWrapper(PartitionTaskWrapper partitionTaskWrapper) {
        try {
            TaskContainer.instance.partitionTaskBlockingQueue.put(partitionTaskWrapper);
        }
        catch (InterruptedException e) {
            logger.error("\u5c06\u4efb\u52a1\u653e\u5165\u961f\u5217\u65f6\u88abInterrupted!", (Object)ExceptionUtils.getStackTrace((Throwable)e));
        }
    }
}

