/*
 * Decompiled with CFR 0.152.
 */
package xin.bluesky.leiothrix.worker.msghandler;

import com.alibaba.fastjson.JSON;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xin.bluesky.leiothrix.model.msg.ServerMessage;
import xin.bluesky.leiothrix.worker.ServerMessageHandler;
import xin.bluesky.leiothrix.worker.msghandler.AcquireTaskResponseHandler;
import xin.bluesky.leiothrix.worker.msghandler.ServerChangedHandler;
import xin.bluesky.leiothrix.worker.msghandler.TaskCancelHandler;

public class ServerChannelInboundHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger logger = LoggerFactory.getLogger(ServerChannelInboundHandler.class);
    private static final Map<String, ServerMessageHandler> map = new HashMap<String, ServerMessageHandler>();

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        super.channelRegistered(ctx);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        super.channelRead(ctx, msg);
        ServerMessage serverMessage = (ServerMessage)JSON.parseObject((String)((String)msg), ServerMessage.class);
        ServerMessageHandler handler = map.get(serverMessage.getType());
        if (handler == null) {
            return;
        }
        handler.handle(ctx, serverMessage.getData());
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        logger.error(ExceptionUtils.getStackTrace((Throwable)cause));
        ctx.close();
    }

    static {
        map.put("acquireTask", new AcquireTaskResponseHandler());
        map.put("serverChanged", new ServerChangedHandler());
        map.put("cancelTask", new TaskCancelHandler());
    }
}

