/*
 * Decompiled with CFR 0.152.
 */
package xin.bluesky.leiothrix.worker.report;

import com.alibaba.fastjson.JSON;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xin.bluesky.leiothrix.model.msg.WorkerMessage;
import xin.bluesky.leiothrix.model.task.partition.PartitionTaskProgress;
import xin.bluesky.leiothrix.worker.WorkerProcessor;
import xin.bluesky.leiothrix.worker.client.ServerChannel;
import xin.bluesky.leiothrix.worker.conf.Settings;

public class WorkerProgressReporter
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(WorkerProgressReporter.class);
    private static ExecutorService reporter = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("worker-status-report").build());
    private static BlockingQueue<PartitionTaskProgress> processingPartitionTaskQueue = new LinkedBlockingDeque<PartitionTaskProgress>();

    public void start() {
        logger.info("\u542f\u52a8\u5411server\u4e0a\u62a5worker\u6267\u884c\u8fdb\u5ea6\u7684\u7ebf\u7a0b");
        reporter.submit(this);
    }

    public void reportProgress(PartitionTaskProgress progress) {
        processingPartitionTaskQueue.offer(progress);
    }

    @Override
    public void run() {
        while (WorkerProcessor.getProcessor().isRunning()) {
            try {
                PartitionTaskProgress progress = processingPartitionTaskQueue.take();
                String localIp = Settings.getWorkerIp();
                WorkerMessage message = new WorkerMessage("workerProgressReport", JSON.toJSONString((Object)progress), localIp);
                ServerChannel.send(message);
                logger.debug("worker:{}\u6267\u884c\u4efb\u52a1\u7247[taskId={},tableName={},rangeName={}],\u5f53\u524d\u6267\u884c\u5230{}", new Object[]{localIp, progress.getPartitionTask().getTaskId(), progress.getPartitionTask().getTableName(), progress.getPartitionTask().getRangeName(), progress.getEndIndex()});
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void shutdown() {
        reporter.shutdownNow();
        this.waitTerminated();
        logger.info("\u6210\u529f\u5173\u95ed\u5411server\u4e0a\u62a5worker\u6267\u884c\u8fdb\u5ea6\u7684\u7ebf\u7a0b");
    }

    private void waitTerminated() {
        while (!reporter.isTerminated()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                logger.error("\u5411server\u4e0a\u62a5worker\u6267\u884c\u8fdb\u5ea6\u7684\u7ebf\u7a0b\u5728\u5173\u95ed\u7684\u65f6\u5019\u88ab\u4e2d\u65ad");
            }
        }
    }
}

