/*
 * Decompiled with CFR 0.152.
 */
package xin.manong.stream.sdk.common;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import xin.manong.weapon.base.record.KVRecord;
import xin.manong.weapon.base.record.KVRecords;

public class ProcessResult
implements Serializable {
    private Map<String, KVRecords> forkMap = new HashMap<String, KVRecords>();

    public int getForkCount() {
        return this.forkMap.size();
    }

    public Set<String> getForks() {
        return this.forkMap.keySet();
    }

    public KVRecords getRecords(String fork) {
        if (StringUtils.isEmpty((CharSequence)fork)) {
            return null;
        }
        return this.forkMap.getOrDefault(fork, null);
    }

    public void addRecord(String fork, KVRecord kvRecord) {
        if (StringUtils.isEmpty((CharSequence)fork) || kvRecord == null) {
            return;
        }
        if (!this.forkMap.containsKey(fork)) {
            this.forkMap.put(fork, new KVRecords());
        }
        this.forkMap.get(fork).addRecord(kvRecord);
    }

    public void addRecord(String fork, KVRecords kvRecords) {
        if (StringUtils.isEmpty((CharSequence)fork) || kvRecords == null) {
            return;
        }
        if (!this.forkMap.containsKey(fork)) {
            this.forkMap.put(fork, new KVRecords());
        }
        this.forkMap.get(fork).addRecords(kvRecords);
    }

    public void addResult(ProcessResult processResult) {
        for (Map.Entry<String, KVRecords> entry : processResult.forkMap.entrySet()) {
            this.addRecord(entry.getKey(), entry.getValue());
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (Map.Entry<String, KVRecords> entry : this.forkMap.entrySet()) {
            buffer.append("fork=").append(entry.getKey()).append(", records=").append(entry.getValue().getRecordCount()).append("\n");
            buffer.append(entry.getValue().toString());
        }
        return buffer.toString();
    }
}

