/*
 * Decompiled with CFR 0.152.
 */
package xyz.baldeep.filter.core;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Set;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.CollectionAttribute;
import javax.persistence.metamodel.ListAttribute;
import javax.persistence.metamodel.MapAttribute;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SetAttribute;
import javax.persistence.metamodel.SingularAttribute;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.query.criteria.internal.path.PluralAttributePath;
import org.hibernate.query.criteria.internal.path.SingularAttributePath;
import org.springframework.data.jpa.domain.Specification;
import xyz.baldeep.filter.core.SearchCriteria;

public class SearchSpecification<T>
implements Specification<T> {
    private static final Logger log = LogManager.getLogger(SearchSpecification.class);
    private static final long serialVersionUID = 1L;
    private SearchCriteria criteria;

    public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder criteriaBuilder) {
        Path path = this.parseProperty(root);
        log.info("Info: {}", (Object)this.criteria);
        switch (this.criteria.getType()) {
            case NUM: {
                switch (this.criteria.getOperation()) {
                    case ">": {
                        return criteriaBuilder.gt((Expression)path, (Number)new BigDecimal(this.criteria.getValue()));
                    }
                    case "<": {
                        return criteriaBuilder.lt((Expression)path, (Number)new BigDecimal(this.criteria.getValue()));
                    }
                    case "=": {
                        return criteriaBuilder.equal((Expression)path, (Object)new BigDecimal(this.criteria.getValue()));
                    }
                    case "!=": {
                        return criteriaBuilder.notEqual((Expression)path, (Object)new BigDecimal(this.criteria.getValue()));
                    }
                    case ">=": {
                        return criteriaBuilder.ge((Expression)path, (Number)new BigDecimal(this.criteria.getValue()));
                    }
                    case "<=": {
                        return criteriaBuilder.le((Expression)path, (Number)new BigDecimal(this.criteria.getValue()));
                    }
                    case "*": {
                        CriteriaBuilder.In in = criteriaBuilder.in((Expression)path);
                        for (String str : this.criteria.getValue().split(",")) {
                            in.value((Object)new BigDecimal(str));
                        }
                        return in;
                    }
                    case "!*": {
                        CriteriaBuilder.In in = criteriaBuilder.in((Expression)path);
                        for (String str : this.criteria.getValue().split(",")) {
                            in.value((Object)new BigDecimal(str));
                        }
                        return in.not();
                    }
                }
                return null;
            }
            case DATE_TIME: {
                switch (this.criteria.getOperation()) {
                    case ">": {
                        return criteriaBuilder.greaterThan((Expression)path, (Comparable)LocalDateTime.parse(this.criteria.getValue()));
                    }
                    case "<": {
                        return criteriaBuilder.lessThan((Expression)path, (Comparable)LocalDateTime.parse(this.criteria.getValue()));
                    }
                    case "=": {
                        return criteriaBuilder.equal((Expression)path, (Object)LocalDateTime.parse(this.criteria.getValue()));
                    }
                    case "!=": {
                        return criteriaBuilder.notEqual((Expression)path, (Object)LocalDateTime.parse(this.criteria.getValue()));
                    }
                    case ">=": {
                        return criteriaBuilder.greaterThanOrEqualTo((Expression)path, (Comparable)LocalDateTime.parse(this.criteria.getValue()));
                    }
                    case "<=": {
                        return criteriaBuilder.lessThanOrEqualTo((Expression)path, (Comparable)LocalDateTime.parse(this.criteria.getValue()));
                    }
                    case "><": {
                        String[] between = this.criteria.getValue().split(",");
                        return criteriaBuilder.between((Expression)path, (Comparable)LocalDateTime.parse(between[0]), (Comparable)LocalDateTime.parse(between[1]));
                    }
                    case "*": {
                        CriteriaBuilder.In in = criteriaBuilder.in((Expression)path);
                        for (String str : this.criteria.getValue().split(",")) {
                            in.value((Object)LocalDateTime.parse(str));
                        }
                        return in;
                    }
                    case "!*": {
                        CriteriaBuilder.In in = criteriaBuilder.in((Expression)path);
                        for (String str : this.criteria.getValue().split(",")) {
                            in.value((Object)LocalDateTime.parse(str));
                        }
                        return in.not();
                    }
                }
                return null;
            }
            case STRING: {
                switch (this.criteria.getOperation()) {
                    case "=": {
                        return criteriaBuilder.equal((Expression)path, (Object)this.criteria.getValue());
                    }
                    case "!=": {
                        return criteriaBuilder.notEqual((Expression)path, (Object)this.criteria.getValue());
                    }
                    case "~": {
                        return criteriaBuilder.like(criteriaBuilder.lower((Expression)path), String.format("%%%s%%", this.criteria.getValue().toLowerCase()));
                    }
                    case "!~": {
                        return criteriaBuilder.notLike(criteriaBuilder.lower((Expression)path), String.format("%%%s%%", this.criteria.getValue().toLowerCase()));
                    }
                    case "~~": {
                        return criteriaBuilder.like((Expression)path, String.format("%%%s%%", this.criteria.getValue()));
                    }
                    case "!~~": {
                        return criteriaBuilder.notLike((Expression)path, String.format("%%%s%%", this.criteria.getValue()));
                    }
                    case "*": {
                        CriteriaBuilder.In in = criteriaBuilder.in(criteriaBuilder.lower((Expression)path));
                        for (String str : this.criteria.getValue().split(",")) {
                            in.value((Object)str.toLowerCase());
                        }
                        return in;
                    }
                    case "!*": {
                        CriteriaBuilder.In in = criteriaBuilder.in(criteriaBuilder.lower((Expression)path));
                        for (String str : this.criteria.getValue().split(",")) {
                            in.value((Object)str.toLowerCase());
                        }
                        return in.not();
                    }
                }
                return null;
            }
            case BOOLEAN: {
                return criteriaBuilder.equal((Expression)path, (Object)Boolean.parseBoolean(this.criteria.getValue()));
            }
        }
        return null;
    }

    private Path parseProperty(Root<T> root) {
        Path path;
        if (this.criteria.getKey().contains(".")) {
            String[] pathSteps = this.criteria.getKey().split("\\.");
            String step = pathSteps[0];
            path = root.get(step);
            Join lastFrom = root;
            for (int i = 1; i <= pathSteps.length - 1; ++i) {
                Join join;
                PluralAttribute attr;
                if (path instanceof PluralAttributePath) {
                    attr = ((PluralAttributePath)path).getAttribute();
                    join = this.getJoin(attr, (From)lastFrom);
                    path = join.get(pathSteps[i]);
                    lastFrom = join;
                    continue;
                }
                if (path instanceof SingularAttributePath) {
                    attr = ((SingularAttributePath)path).getAttribute();
                    if (attr.getPersistentAttributeType() != Attribute.PersistentAttributeType.BASIC) {
                        join = lastFrom.join((SingularAttribute)attr, JoinType.LEFT);
                        path = join.get(pathSteps[i]);
                        lastFrom = join;
                        continue;
                    }
                    path = path.get(pathSteps[i]);
                    continue;
                }
                path = path.get(pathSteps[i]);
            }
        } else {
            path = root.get(this.criteria.getKey());
        }
        return path;
    }

    private Join getJoin(PluralAttribute attr, From from) {
        Set joins = from.getJoins();
        for (Object object : joins) {
            Join join = (Join)object;
            if (!join.getAttribute().getName().equals(attr.getName())) continue;
            return join;
        }
        return this.createJoin(attr, from);
    }

    private Join createJoin(PluralAttribute attr, From from) {
        switch (attr.getCollectionType()) {
            case COLLECTION: {
                return from.join((CollectionAttribute)attr);
            }
            case SET: {
                return from.join((SetAttribute)attr);
            }
            case LIST: {
                return from.join((ListAttribute)attr);
            }
            case MAP: {
                return from.join((MapAttribute)attr);
            }
        }
        return null;
    }

    public SearchSpecification() {
    }

    public SearchSpecification(SearchCriteria criteria) {
        this.criteria = criteria;
    }
}

