/*
 * Decompiled with CFR 0.152.
 */
package xyz.baldeep.filter.core;

import java.lang.reflect.Field;
import java.util.regex.Matcher;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.util.ReflectionUtils;
import xyz.baldeep.filter.core.Constants;
import xyz.baldeep.filter.core.SearchSpecificationBuilder;

public final class SearchUtil {
    private static final Logger log = LogManager.getLogger(SearchUtil.class);

    public static <T> Specification<T> createSpec(String query, Class klaz) {
        SearchSpecificationBuilder builder = new SearchSpecificationBuilder();
        Matcher matcher = Constants.SEARCH_QUERY_PATTERN.matcher(query + ",");
        while (matcher.find()) {
            String key = matcher.group(3);
            builder.with(matcher.group(1), SearchUtil.getTypeFromEntity(key, klaz), key, matcher.group(4), matcher.group(5).replaceAll("\"", ""));
        }
        return builder.build();
    }

    public static String getTypeFromEntity(String key, Class klaz) {
        try {
            String[] splitKey = key.split("\\.");
            if (splitKey.length == 1) {
                log.info("Key: {}", (Object)key);
                Field field = ReflectionUtils.findField((Class)klaz, (String)key);
                if (field != null) {
                    log.info("Field Type: {}", (Object)field.getType().getCanonicalName());
                    switch (field.getType().getCanonicalName()) {
                        case "java.time.LocalDateTime": {
                            return "DT";
                        }
                        case "java.lang.Integer": 
                        case "int": {
                            return "N";
                        }
                        case "int[]": {
                            return "A";
                        }
                        case "boolean": 
                        case "java.lang.Boolean": {
                            return "B";
                        }
                    }
                    return "S";
                }
            } else {
                Field parentField = ReflectionUtils.findField((Class)klaz, (String)splitKey[0]);
                System.out.println("com.bsk.filter.SearchUtil.parentField()" + parentField.getType());
                String res = SearchUtil.getTypeFromEntity(splitKey[1], parentField.getType());
                System.out.println("res::" + res);
                return res;
            }
            return "S";
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }
}

