/*
 * Decompiled with CFR 0.152.
 */
package xyz.baldeep.filter.dao;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Tuple;
import javax.persistence.TupleElement;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.query.QueryUtils;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;
import org.springframework.data.repository.support.PageableExecutionUtils;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import xyz.baldeep.filter.dao.BaseDao;

public class BaseDaoImpl<T, ID extends Serializable>
extends SimpleJpaRepository<T, ID>
implements BaseDao<T, ID> {
    private EntityManager entityManager;

    public BaseDaoImpl(JpaEntityInformation<T, ?> entityInformation, EntityManager entityManager) {
        super(entityInformation, entityManager);
        this.entityManager = entityManager;
    }

    @Override
    public Page<?> findAll(Specification<T> specs, Pageable pageable, List<String> fields) {
        try {
            if (CollectionUtils.isEmpty(fields)) {
                return super.findAll(specs, pageable);
            }
            Assert.notNull((Object)pageable, (String)"Pageable must be not null!");
            Assert.notEmpty(fields, (String)"Fields must not be empty!");
            CriteriaBuilder builder = this.entityManager.getCriteriaBuilder();
            CriteriaQuery query = builder.createTupleQuery();
            Root<T> root = this.applySpecToCriteria(query, builder, specs);
            List<Selection<?>> selections = this.getSelections(fields, root);
            query.multiselect(selections);
            this.applySorting(builder, query, root, pageable);
            return this.getPageableResultList((CriteriaQuery<Tuple>)query, specs, pageable);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private <R> Root<T> applySpecToCriteria(CriteriaQuery<R> query, CriteriaBuilder builder, Specification<T> specs) {
        Assert.notNull(query, (String)"CriteriaQuery must not be null!");
        Root root = query.from(this.getDomainClass());
        if (specs == null) {
            return root;
        }
        Predicate predicate = specs.toPredicate(root, query, builder);
        if (predicate != null) {
            query.where((Expression)predicate);
        }
        return root;
    }

    private List<Selection<?>> getSelections(List<String> fields, Root<T> root) {
        ArrayList selections = new ArrayList();
        for (String field : fields) {
            selections.add(root.get(field).alias(field));
        }
        return selections;
    }

    private <R> void applySorting(CriteriaBuilder builder, CriteriaQuery<R> query, Root<T> root, Pageable pageable) {
        Sort sort;
        Sort sort2 = sort = pageable.isPaged() ? pageable.getSort() : Sort.unsorted();
        if (sort.isSorted()) {
            query.orderBy(QueryUtils.toOrders((Sort)sort, root, (CriteriaBuilder)builder));
        }
    }

    private Page<?> getPageableResultList(CriteriaQuery<Tuple> query, Specification spec, Pageable pageable) {
        TypedQuery typedQuery = this.entityManager.createQuery(query);
        Class domainClass = this.getDomainClass();
        if (pageable.isPaged()) {
            typedQuery.setFirstResult((int)pageable.getOffset());
            typedQuery.setMaxResults(pageable.getPageSize());
            List results = typedQuery.getResultList();
            ArrayList projectedResults = new ArrayList(results.size());
            for (Tuple tuple : results) {
                HashMap<String, Object> mappedResult = new HashMap<String, Object>(tuple.getElements().size());
                for (TupleElement element : tuple.getElements()) {
                    String name = element.getAlias();
                    mappedResult.put(name, tuple.get(name));
                }
                projectedResults.add(mappedResult);
            }
            return PageableExecutionUtils.getPage(projectedResults, (Pageable)pageable, () -> BaseDaoImpl.executeCountQuery((TypedQuery<Long>)this.getCountQuery(spec, domainClass)));
        }
        return new PageImpl(typedQuery.getResultList());
    }

    private static long executeCountQuery(TypedQuery<Long> query) {
        Assert.notNull(query, (String)"TypedQuery must not be null!");
        List totals = query.getResultList();
        long total = 0L;
        for (Long element : totals) {
            total += element == null ? 0L : element;
        }
        return total;
    }
}

