/*
 * Decompiled with CFR 0.152.
 */
package web5.sdk.common;

import java.util.Base64;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import web5.sdk.common.Base58Btc;
import web5.sdk.common.ConvertKt;
import web5.sdk.common.EncodingFormat;
import web5.sdk.common.ZBase32;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0019\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\b\u001a\u00020\tH\u0002J\u0006\u0010\n\u001a\u00020\u000bJ\u0012\u0010\f\u001a\u00020\u000b2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0007J\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u000bJ\u0006\u0010\u0012\u001a\u00020\u000bR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0003\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lweb5/sdk/common/Convert;", "T", "", "value", "kind", "Lweb5/sdk/common/EncodingFormat;", "(Ljava/lang/Object;Lweb5/sdk/common/EncodingFormat;)V", "Ljava/lang/Object;", "handleNotSupported", "", "toBase58Btc", "", "toBase64Url", "padding", "", "toByteArray", "", "toStr", "toZBase32", "common"})
public final class Convert<T> {
    private final T value;
    @Nullable
    private final EncodingFormat kind;

    public Convert(T value, @Nullable EncodingFormat kind) {
        this.value = value;
        this.kind = kind;
    }

    public /* synthetic */ Convert(Object object, EncodingFormat encodingFormat, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            encodingFormat = null;
        }
        this(object, encodingFormat);
    }

    @JvmOverloads
    @NotNull
    public final String toBase64Url(boolean padding) {
        Base64.Encoder encoder = padding ? ConvertKt.getB64URL_ENCODER() : ConvertKt.getB64URL_ENCODER().withoutPadding();
        T t = this.value;
        if (!(t instanceof byte[])) {
            if (t instanceof String) {
                String string;
                EncodingFormat encodingFormat = this.kind;
                switch (encodingFormat == null ? -1 : WhenMappings.$EnumSwitchMapping$0[encodingFormat.ordinal()]) {
                    case 1: {
                        string = (String)this.value;
                        break;
                    }
                    case -1: {
                        String string2 = encoder.encodeToString(this.toByteArray());
                        string = string2;
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"encodeToString(...)");
                        break;
                    }
                    default: {
                        this.handleNotSupported();
                        throw new KotlinNothingValueException();
                    }
                }
                return string;
            }
            this.handleNotSupported();
            throw new KotlinNothingValueException();
        }
        String string = encoder.encodeToString((byte[])this.value);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeToString(...)");
        return string;
    }

    public static /* synthetic */ String toBase64Url$default(Convert convert, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return convert.toBase64Url(bl);
    }

    @NotNull
    public final String toBase58Btc() {
        T t = this.value;
        if (!(t instanceof byte[])) {
            if (t instanceof String) {
                String string;
                EncodingFormat encodingFormat = this.kind;
                switch (encodingFormat == null ? -1 : WhenMappings.$EnumSwitchMapping$0[encodingFormat.ordinal()]) {
                    case 2: {
                        string = (String)this.value;
                        break;
                    }
                    case 1: {
                        byte[] byArray = ConvertKt.getB64URL_DECODER().decode((String)this.value);
                        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(...)");
                        string = Base58Btc.INSTANCE.encode(byArray);
                        break;
                    }
                    case 3: {
                        string = Base58Btc.INSTANCE.encode(ZBase32.INSTANCE.decode((String)this.value));
                        break;
                    }
                    case -1: {
                        string = Base58Btc.INSTANCE.encode(this.toByteArray());
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return string;
            }
            this.handleNotSupported();
            throw new KotlinNothingValueException();
        }
        return Base58Btc.INSTANCE.encode((byte[])this.value);
    }

    @NotNull
    public final String toZBase32() {
        T t = this.value;
        if (!(t instanceof byte[])) {
            if (t instanceof String) {
                String string;
                EncodingFormat encodingFormat = this.kind;
                switch (encodingFormat == null ? -1 : WhenMappings.$EnumSwitchMapping$0[encodingFormat.ordinal()]) {
                    case 2: {
                        string = ZBase32.INSTANCE.encode(Base58Btc.INSTANCE.decode((String)this.value));
                        break;
                    }
                    case 1: {
                        byte[] byArray = ConvertKt.getB64URL_DECODER().decode((String)this.value);
                        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(...)");
                        string = ZBase32.INSTANCE.encode(byArray);
                        break;
                    }
                    case 3: {
                        string = (String)this.value;
                        break;
                    }
                    case -1: {
                        string = ZBase32.INSTANCE.encode(this.toByteArray());
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return string;
            }
            this.handleNotSupported();
            throw new KotlinNothingValueException();
        }
        return ZBase32.INSTANCE.encode((byte[])this.value);
    }

    @NotNull
    public final String toStr() {
        T t = this.value;
        if (!(t instanceof byte[])) {
            if (t instanceof String) {
                String string;
                EncodingFormat encodingFormat = this.kind;
                switch (encodingFormat == null ? -1 : WhenMappings.$EnumSwitchMapping$0[encodingFormat.ordinal()]) {
                    case 1: {
                        byte[] byArray = ConvertKt.getB64URL_DECODER().decode((String)this.value);
                        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(...)");
                        byte[] byArray2 = byArray;
                        string = new String(byArray2, Charsets.UTF_8);
                        break;
                    }
                    case 3: {
                        string = new String(ZBase32.INSTANCE.decode((String)this.value), Charsets.UTF_8);
                        break;
                    }
                    case -1: {
                        string = (String)this.value;
                        break;
                    }
                    default: {
                        this.handleNotSupported();
                        throw new KotlinNothingValueException();
                    }
                }
                return string;
            }
            this.handleNotSupported();
            throw new KotlinNothingValueException();
        }
        return new String((byte[])this.value, Charsets.UTF_8);
    }

    @NotNull
    public final byte[] toByteArray() {
        T t = this.value;
        if (!(t instanceof byte[])) {
            if (t instanceof String) {
                byte[] byArray;
                EncodingFormat encodingFormat = this.kind;
                switch (encodingFormat == null ? -1 : WhenMappings.$EnumSwitchMapping$0[encodingFormat.ordinal()]) {
                    case 2: {
                        byArray = Base58Btc.INSTANCE.decode((String)this.value);
                        break;
                    }
                    case 1: {
                        byte[] byArray2 = ConvertKt.getB64URL_DECODER().decode((String)this.value);
                        byArray = byArray2;
                        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"decode(...)");
                        break;
                    }
                    case 3: {
                        byArray = ZBase32.INSTANCE.decode((String)this.value);
                        break;
                    }
                    case -1: {
                        String string = (String)this.value;
                        byte[] byArray3 = string.getBytes(Charsets.UTF_8);
                        byArray = byArray3;
                        Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"getBytes(...)");
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return byArray;
            }
            this.handleNotSupported();
            throw new KotlinNothingValueException();
        }
        return (byte[])this.value;
    }

    private final Void handleNotSupported() {
        T t = this.value;
        if (t != null) {
            T it = t;
            boolean bl = false;
            throw new UnsupportedOperationException("converting from " + Reflection.getOrCreateKotlinClass(it.getClass()) + " not supported");
        }
        throw new NullPointerException("value is null");
    }

    @JvmOverloads
    @NotNull
    public final String toBase64Url() {
        return Convert.toBase64Url$default(this, false, 1, null);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EncodingFormat.values().length];
            try {
                nArray[EncodingFormat.Base64Url.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EncodingFormat.Base58Btc.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EncodingFormat.ZBase32.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

