/*
 * Decompiled with CFR 0.152.
 */
package xyz.iotcode.iadmin.core.wrapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.iotcode.iadmin.core.wrapper.QueryCondition;

public class WrapperFactory<T> {
    private static Pattern HUMP_PATTERN = Pattern.compile("[A-Z]");
    private static final String EMPTY = "";
    private Logger log = LoggerFactory.getLogger(WrapperFactory.class);

    public QueryWrapper<T> create(Object dto) {
        QueryWrapper wrapper = new QueryWrapper();
        this.create(wrapper, dto);
        return wrapper;
    }

    public void create(QueryWrapper wrapper, Object dto) {
        Field[] declaredFields;
        Class<?> dtoClass = dto.getClass();
        for (Field field : declaredFields = WrapperFactory.getAllFields(dtoClass)) {
            field.setAccessible(true);
            Object value = null;
            try {
                value = field.get(dto);
            }
            catch (IllegalAccessException e) {
                this.log.error("\u901a\u8fc7\u53cd\u5c04\u83b7\u53d6\u5c5e\u6027\u503c\u51fa\u9519\uff1a" + e);
            }
            QueryCondition query = field.getAnnotation(QueryCondition.class);
            if (query == null) continue;
            if (!query.condition().equals((Object)QueryCondition.Condition.DEFAULT) && !WrapperFactory.isEmpty(value)) {
                switch (query.condition()) {
                    case EQ: {
                        wrapper.eq((Object)this.getColumnName(field), value);
                        break;
                    }
                    case IN: {
                        if (!(value instanceof Collection) || ((Collection)value).size() <= 0) break;
                        wrapper.in((Object)this.getColumnName(field), (Collection)value);
                        break;
                    }
                    case LIKE: {
                        wrapper.like((Object)this.getColumnName(field), value);
                        break;
                    }
                    case GE: {
                        wrapper.ge((Object)this.getColumnName(field), value);
                        break;
                    }
                    case LE: {
                        wrapper.le((Object)this.getColumnName(field), value);
                        break;
                    }
                }
            }
            if (query.sort().equals((Object)QueryCondition.Sort.DEFAULT)) continue;
            if (query.sort().equals((Object)QueryCondition.Sort.DESC)) {
                wrapper.orderByDesc((Object)this.getColumnName(field));
                continue;
            }
            if (query.sort().equals((Object)QueryCondition.Sort.ASC)) {
                wrapper.orderByAsc((Object)this.getColumnName(field));
                continue;
            }
            if (value == null) continue;
            if (value.equals("asc") || value.equals("ASC") || value.equals(0)) {
                wrapper.orderByAsc((Object)this.getColumnName(field));
                continue;
            }
            wrapper.orderByDesc((Object)this.getColumnName(field));
        }
    }

    private String getColumnName(Field field) {
        QueryCondition annotation = field.getAnnotation(QueryCondition.class);
        if (annotation.field().isEmpty()) {
            return this.humpToLine(field.getName());
        }
        return annotation.field();
    }

    private String humpToLine(String str) {
        Matcher matcher = HUMP_PATTERN.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, "_" + matcher.group(0).toLowerCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private static Field[] getAllFields(Class<?> cls) {
        List<Field> allFieldsList = WrapperFactory.getAllFieldsList(cls);
        return allFieldsList.toArray(new Field[0]);
    }

    private static List<Field> getAllFieldsList(Class<?> cls) {
        if (cls == null) {
            throw new IllegalArgumentException("The class must not be null");
        }
        ArrayList<Field> allFields = new ArrayList<Field>();
        for (Class<?> currentClass = cls; currentClass != null; currentClass = currentClass.getSuperclass()) {
            Field[] declaredFields = currentClass.getDeclaredFields();
            allFields.addAll(Arrays.asList(declaredFields));
        }
        return allFields;
    }

    public static boolean isEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).size() == 0;
        }
        if (obj instanceof String) {
            return EMPTY.equals(((String)obj).trim());
        }
        return false;
    }
}

