/*
 * Decompiled with CFR 0.152.
 */
package xyz.malefic.theme.util;

import androidx.compose.ui.graphics.ColorKt;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;
import xyz.malefic.theme.SerializableThemeConfig;
import xyz.malefic.theme.ThemeConfig;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0013\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"loadThemeFromJson", "Lxyz/malefic/theme/ThemeConfig;", "filePath", "", "parseHexColor", "Landroidx/compose/ui/graphics/Color;", "hex", "(Ljava/lang/String;)J", "MaleficTheming"})
public final class FunctionsKt {
    @NotNull
    public static final ThemeConfig loadThemeFromJson(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        String jsonContent = FilesKt.readText$default((File)new File(filePath), null, (int)1, null);
        SerializableThemeConfig parsedConfig = (SerializableThemeConfig)Json.Default.decodeFromString((DeserializationStrategy)SerializableThemeConfig.Companion.serializer(), jsonContent);
        return new ThemeConfig(FunctionsKt.parseHexColor(parsedConfig.getPrimary()), FunctionsKt.parseHexColor(parsedConfig.getPrimaryVariant()), FunctionsKt.parseHexColor(parsedConfig.getSecondary()), FunctionsKt.parseHexColor(parsedConfig.getSecondaryVariant()), FunctionsKt.parseHexColor(parsedConfig.getBackground()), FunctionsKt.parseHexColor(parsedConfig.getSurface()), FunctionsKt.parseHexColor(parsedConfig.getError()), FunctionsKt.parseHexColor(parsedConfig.getOnPrimary()), FunctionsKt.parseHexColor(parsedConfig.getOnSecondary()), FunctionsKt.parseHexColor(parsedConfig.getOnBackground()), FunctionsKt.parseHexColor(parsedConfig.getOnSurface()), FunctionsKt.parseHexColor(parsedConfig.getOnError()), parsedConfig.isLight(), null);
    }

    public static final long parseHexColor(@NotNull String hex) {
        Intrinsics.checkNotNullParameter((Object)hex, (String)"hex");
        String cleanedHex = StringsKt.removePrefix((String)hex, (CharSequence)"#");
        return switch (cleanedHex.length()) {
            case 6 -> {
                long colorValue = Long.parseLong(cleanedHex, CharsKt.checkRadix((int)16)) | 0xFF000000L;
                yield ColorKt.Color((int)((int)colorValue));
            }
            case 8 -> {
                long colorValue = Long.parseLong(cleanedHex, CharsKt.checkRadix((int)16));
                yield ColorKt.Color((int)((int)colorValue));
            }
            default -> throw new IllegalArgumentException("Invalid color hex string: " + hex);
        };
    }
}

