/*
 * Decompiled with CFR 0.152.
 */
package xyz.migoo.framework.cvs.core.client;

import cn.hutool.core.util.StrUtil;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.util.Assert;
import xyz.migoo.framework.common.exception.ErrorCode;
import xyz.migoo.framework.common.exception.util.ServiceExceptionUtil;
import xyz.migoo.framework.cvs.core.client.AbstractCVSClient;
import xyz.migoo.framework.cvs.core.client.CVSClient;
import xyz.migoo.framework.cvs.core.client.CVSClientFactory;
import xyz.migoo.framework.cvs.core.client.aliyun.ECSClient;
import xyz.migoo.framework.cvs.core.client.tencent.RDSClient;
import xyz.migoo.framework.cvs.core.enums.CVSMachineType;
import xyz.migoo.framework.cvs.core.enums.CVSProvide;
import xyz.migoo.framework.cvs.core.property.CVSClientProperties;

public class CVSClientFactoryImpl
implements CVSClientFactory {
    private final ConcurrentMap<String, AbstractCVSClient> channelIdClients = new ConcurrentHashMap<String, AbstractCVSClient>();

    @Override
    public CVSClient getClient(Long id, CVSMachineType type) {
        return (CVSClient)this.channelIdClients.get(id + "_" + String.valueOf((Object)type));
    }

    @Override
    public void createOrUpdateClient(CVSClientProperties properties, CVSMachineType type) {
        String key = properties.getId() + "_" + String.valueOf((Object)type);
        AbstractCVSClient client = (AbstractCVSClient)this.channelIdClients.get(key);
        if (client == null) {
            client = this.createClient(properties, type);
            client.initialization();
            this.channelIdClients.put(key, client);
        } else {
            client.refresh(properties);
        }
    }

    private AbstractCVSClient createClient(CVSClientProperties properties, CVSMachineType type) {
        CVSProvide provide = CVSProvide.valueOf(properties.getCode().toUpperCase(Locale.ROOT));
        Assert.notNull((Object)((Object)provide), (String)String.format("\u670d\u52a1\u5546(%s) \u4e3a\u7a7a", properties.getCode()));
        if (provide == CVSProvide.ALI_CLOUD && type == CVSMachineType.ECS) {
            return new ECSClient(properties);
        }
        if (provide == CVSProvide.ALI_CLOUD && type == CVSMachineType.RDS) {
            return new xyz.migoo.framework.cvs.core.client.aliyun.RDSClient(properties);
        }
        if (provide == CVSProvide.TENCENT && type == CVSMachineType.ECS) {
            return new xyz.migoo.framework.cvs.core.client.tencent.ECSClient(properties);
        }
        if (provide == CVSProvide.TENCENT && type == CVSMachineType.RDS) {
            return new RDSClient(properties);
        }
        throw ServiceExceptionUtil.get((ErrorCode)new ErrorCode(Integer.valueOf(-1), StrUtil.format((CharSequence)"\u65e0\u53ef\u7528\u4e91\u670d\u52a1\u5546\u5ba2\u6237\u7aef: {}, {}", (Object[])new Object[]{provide.name(), type.name()})));
    }
}

