/*
 * Decompiled with CFR 0.152.
 */
package xyz.migoo.framework.cvs.core.client.aliyun;

import cn.hutool.core.date.DateUtil;
import com.aliyun.auth.credentials.Credential;
import com.aliyun.auth.credentials.provider.ICredentialProvider;
import com.aliyun.auth.credentials.provider.StaticCredentialProvider;
import com.aliyun.sdk.service.ecs20140526.AsyncClient;
import com.aliyun.sdk.service.ecs20140526.DefaultAsyncClientBuilder;
import com.aliyun.sdk.service.ecs20140526.models.DescribeInstancesRequest;
import com.aliyun.sdk.service.ecs20140526.models.DescribeInstancesResponse;
import com.aliyun.sdk.service.ecs20140526.models.DescribeInstancesResponseBody;
import com.aliyun.sdk.service.ecs20140526.models.DescribeRenewalPriceRequest;
import com.aliyun.sdk.service.ecs20140526.models.DescribeRenewalPriceResponse;
import com.aliyun.sdk.service.ecs20140526.models.RebootInstanceRequest;
import com.aliyun.sdk.service.ecs20140526.models.StartInstanceRequest;
import com.aliyun.sdk.service.ecs20140526.models.StopInstanceRequest;
import com.google.common.collect.Lists;
import darabonba.core.client.ClientOverrideConfiguration;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.migoo.framework.common.pojo.Result;
import xyz.migoo.framework.common.util.json.JsonUtils;
import xyz.migoo.framework.cvs.core.client.AbstractCVSClient;
import xyz.migoo.framework.cvs.core.client.dto.CVMachineInstanceRespDTO;
import xyz.migoo.framework.cvs.core.client.dto.InstanceStatus;
import xyz.migoo.framework.cvs.core.enums.CVSMachineType;
import xyz.migoo.framework.cvs.core.property.CVSClientProperties;

public class ECSClient
extends AbstractCVSClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ECSClient.class);
    private AsyncClient client;

    public ECSClient(CVSClientProperties properties) {
        super(properties);
    }

    @Override
    protected void doInitialization() {
        try (StaticCredentialProvider provider = StaticCredentialProvider.create((Credential)Credential.builder().accessKeyId(this.properties.getAccessKeyId()).accessKeySecret(this.properties.getAccessKeySecret()).build());){
            this.client = (AsyncClient)((DefaultAsyncClientBuilder)((DefaultAsyncClientBuilder)((DefaultAsyncClientBuilder)AsyncClient.builder().region(this.properties.getRegion())).credentialsProvider((ICredentialProvider)provider)).overrideConfiguration(ClientOverrideConfiguration.create().setEndpointOverride("ecs." + this.properties.getRegion() + ".aliyuncs.com"))).build();
        }
    }

    @Override
    public Result<List<CVMachineInstanceRespDTO>> getInstances(String regionId) {
        return this.getInstances(regionId, null);
    }

    @Override
    public Result<List<CVMachineInstanceRespDTO>> getInstances(String regionId, List<String> instanceIds) {
        DescribeInstancesRequest describeInstancesRequest = DescribeInstancesRequest.builder().regionId(regionId).instanceIds(Objects.isNull(instanceIds) ? null : JsonUtils.toJsonString(instanceIds)).pageNumber(Integer.valueOf(1)).pageSize(Integer.valueOf(100)).build();
        ArrayList instances = Lists.newArrayList();
        try {
            DescribeInstancesResponse response = (DescribeInstancesResponse)this.client.describeInstances(describeInstancesRequest).get();
            for (DescribeInstancesResponseBody.Instance instance : response.getBody().getInstances().getInstance()) {
                CVMachineInstanceRespDTO.CVMachineInstanceRespDTOBuilder builder = CVMachineInstanceRespDTO.builder().instanceId(instance.getInstanceId()).hostname(instance.getHostName()).status(InstanceStatus.valueOf(instance.getStatus())).operateSystem(instance.getOSName()).publicIpAddress(Objects.isNull(instance.getPublicIpAddress()) || Objects.isNull(instance.getPublicIpAddress().getIpAddress()) ? null : (String)instance.getPublicIpAddress().getIpAddress().getFirst()).privateIpAddress(Objects.isNull(instance.getInnerIpAddress()) || Objects.isNull(instance.getInnerIpAddress().getIpAddress()) ? null : (String)instance.getInnerIpAddress().getIpAddress().getFirst()).machineType(CVSMachineType.ECS).createdTime(DateUtil.format((Date)DateUtil.parse((CharSequence)instance.getCreationTime(), (String)"yyyy-MM-ddTHH:mmZ"), (String)"yyyy-MM-dd HH:mm:ss")).expiredTime(DateUtil.format((Date)DateUtil.parse((CharSequence)instance.getExpiredTime(), (String)"yyyy-MM-ddTHH:mmZ"), (String)"yyyy-MM-dd HH:mm:ss"));
                if (!Objects.equals((Object)InstanceStatus.valOf(instance.getStatus()), (Object)InstanceStatus.Released)) {
                    DescribeRenewalPriceRequest describeRenewalPriceRequest = DescribeRenewalPriceRequest.builder().regionId(regionId).resourceType("instance").resourceId(instance.getInstanceId()).build();
                    DescribeRenewalPriceResponse price = (DescribeRenewalPriceResponse)this.client.describeRenewalPrice(describeRenewalPriceRequest).get();
                    builder.price(new BigDecimal(price.getBody().getPriceInfo().getPrice().getTradePrice().toString()));
                }
                instances.add(builder.build());
            }
            return Result.getSuccessful((Object)instances);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u963f\u91cc\u4e91ecs\u670d\u52a1\u5668\u5f02\u5e38.", (Throwable)e);
            return Result.getError((Integer)-1, (String)"\u83b7\u53d6\u963f\u91cc\u4e91ecs\u670d\u52a1\u5668\u5f02\u5e38.");
        }
    }

    @Override
    public Result<Boolean> start(String instanceId) {
        StartInstanceRequest startInstanceRequest = StartInstanceRequest.builder().instanceId(instanceId).build();
        try {
            this.client.startInstance(startInstanceRequest);
            return Result.getSuccessful((Object)true);
        }
        catch (Exception e) {
            log.error("\u542f\u52a8\u963f\u91cc\u4e91ecs\u670d\u52a1\u5668\u5f02\u5e38.", (Throwable)e);
            return Result.getError((Integer)-1, (String)("\u542f\u52a8\u963f\u91cc\u4e91ecs\u670d\u52a1\u5668\u5f02\u5e38. " + e.getMessage()));
        }
    }

    @Override
    public Result<Boolean> stop(String instanceId) {
        StopInstanceRequest stopInstanceRequest = StopInstanceRequest.builder().instanceId(instanceId).forceStop(Boolean.valueOf(true)).build();
        try {
            this.client.stopInstance(stopInstanceRequest);
            return Result.getSuccessful((Object)true);
        }
        catch (Exception e) {
            log.error("\u5173\u95ed\u963f\u91cc\u4e91ecs\u670d\u52a1\u5668\u5f02\u5e38.", (Throwable)e);
            return Result.getError((Integer)-1, (String)("\u5173\u95ed\u963f\u91cc\u4e91ecs\u670d\u52a1\u5668\u5f02\u5e38. " + e.getMessage()));
        }
    }

    @Override
    public Result<Boolean> reboot(String instanceId) {
        RebootInstanceRequest rebootInstanceRequest = RebootInstanceRequest.builder().instanceId(instanceId).forceStop(Boolean.valueOf(true)).build();
        try {
            this.client.rebootInstance(rebootInstanceRequest);
            return Result.getSuccessful((Object)true);
        }
        catch (Exception e) {
            log.error("\u91cd\u542f\u963f\u91cc\u4e91ecs\u670d\u52a1\u5668\u5f02\u5e38.", (Throwable)e);
            return Result.getError((Integer)-1, (String)("\u91cd\u542f\u963f\u91cc\u4e91ecs\u670d\u52a1\u5668\u5f02\u5e38. " + e.getMessage()));
        }
    }
}

