/*
 * Decompiled with CFR 0.152.
 */
package xyz.migoo.framework.cvs.core.client.aliyun;

import cn.hutool.core.date.DateUtil;
import com.aliyun.auth.credentials.Credential;
import com.aliyun.auth.credentials.provider.ICredentialProvider;
import com.aliyun.auth.credentials.provider.StaticCredentialProvider;
import com.aliyun.sdk.service.rds20140815.AsyncClient;
import com.aliyun.sdk.service.rds20140815.DefaultAsyncClientBuilder;
import com.aliyun.sdk.service.rds20140815.models.DescribeDBInstancesRequest;
import com.aliyun.sdk.service.rds20140815.models.DescribeDBInstancesResponse;
import com.aliyun.sdk.service.rds20140815.models.DescribeDBInstancesResponseBody;
import com.aliyun.sdk.service.rds20140815.models.DescribeRenewalPriceRequest;
import com.aliyun.sdk.service.rds20140815.models.DescribeRenewalPriceResponse;
import com.aliyun.sdk.service.rds20140815.models.RestartDBInstanceRequest;
import com.aliyun.sdk.service.rds20140815.models.StartDBInstanceRequest;
import com.aliyun.sdk.service.rds20140815.models.StopDBInstanceRequest;
import com.google.common.collect.Lists;
import darabonba.core.client.ClientOverrideConfiguration;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.migoo.framework.common.pojo.Result;
import xyz.migoo.framework.cvs.core.client.AbstractCVSClient;
import xyz.migoo.framework.cvs.core.client.dto.CVMachineInstanceRespDTO;
import xyz.migoo.framework.cvs.core.client.dto.InstanceStatus;
import xyz.migoo.framework.cvs.core.enums.CVSMachineType;
import xyz.migoo.framework.cvs.core.property.CVSClientProperties;

public class RDSClient
extends AbstractCVSClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RDSClient.class);
    private AsyncClient client;

    public RDSClient(CVSClientProperties properties) {
        super(properties);
    }

    @Override
    protected void doInitialization() {
        try (StaticCredentialProvider provider = StaticCredentialProvider.create((Credential)Credential.builder().accessKeyId(this.properties.getAccessKeyId()).accessKeySecret(this.properties.getAccessKeySecret()).build());){
            this.client = (AsyncClient)((DefaultAsyncClientBuilder)((DefaultAsyncClientBuilder)((DefaultAsyncClientBuilder)AsyncClient.builder().region(this.properties.getRegion())).credentialsProvider((ICredentialProvider)provider)).overrideConfiguration(ClientOverrideConfiguration.create().setEndpointOverride("rds." + this.properties.getRegion() + ".aliyuncs.com"))).build();
        }
    }

    @Override
    public Result<List<CVMachineInstanceRespDTO>> getInstances(String regionId) {
        return Result.getSuccessful(this._instances(regionId, null));
    }

    @Override
    public Result<List<CVMachineInstanceRespDTO>> getInstances(String regionId, List<String> instanceIds) {
        ArrayList instances = Lists.newArrayList();
        instanceIds.forEach(item -> instances.addAll(this._instances(regionId, (String)item)));
        return Result.getSuccessful((Object)instances);
    }

    @Override
    public Result<Boolean> start(String instanceId) {
        StartDBInstanceRequest startInstanceRequest = StartDBInstanceRequest.builder().DBInstanceId(instanceId).build();
        try {
            this.client.startDBInstance(startInstanceRequest);
            return Result.getSuccessful((Object)true);
        }
        catch (Exception e) {
            log.error("\u542f\u52a8\u963f\u91cc\u4e91rds\u670d\u52a1\u5668\u5f02\u5e38.", (Throwable)e);
            return Result.getError((Integer)-1, (String)("\u542f\u52a8\u963f\u91cc\u4e91rds\u670d\u52a1\u5668\u5f02\u5e38. " + e.getMessage()));
        }
    }

    @Override
    public Result<Boolean> stop(String instanceId) {
        StopDBInstanceRequest stopInstanceRequest = StopDBInstanceRequest.builder().DBInstanceId(instanceId).build();
        try {
            this.client.stopDBInstance(stopInstanceRequest);
            return Result.getSuccessful((Object)true);
        }
        catch (Exception e) {
            log.error("\u5173\u95ed\u963f\u91cc\u4e91rds\u670d\u52a1\u5668\u5f02\u5e38.", (Throwable)e);
            return Result.getError((Integer)-1, (String)("\u5173\u95ed\u963f\u91cc\u4e91rds\u670d\u52a1\u5668\u5f02\u5e38. " + e.getMessage()));
        }
    }

    @Override
    public Result<Boolean> reboot(String instanceId) {
        RestartDBInstanceRequest rebootInstanceRequest = RestartDBInstanceRequest.builder().DBInstanceId(instanceId).build();
        try {
            this.client.restartDBInstance(rebootInstanceRequest);
            return Result.getSuccessful((Object)true);
        }
        catch (Exception e) {
            log.error("\u91cd\u542f\u963f\u91cc\u4e91rds\u670d\u52a1\u5668\u5f02\u5e38.", (Throwable)e);
            return Result.getError((Integer)-1, (String)("\u91cd\u542f\u963f\u91cc\u4e91rds\u670d\u52a1\u5668\u5f02\u5e38. " + e.getMessage()));
        }
    }

    private List<CVMachineInstanceRespDTO> _instances(String regionId, String instanceId) {
        DescribeDBInstancesRequest describeInstancesRequest = DescribeDBInstancesRequest.builder().regionId(regionId).DBInstanceId(instanceId).pageNumber(Integer.valueOf(1)).pageSize(Integer.valueOf(100)).build();
        ArrayList instances = Lists.newArrayList();
        try {
            DescribeDBInstancesResponse response = (DescribeDBInstancesResponse)this.client.describeDBInstances(describeInstancesRequest).get();
            for (DescribeDBInstancesResponseBody.DBInstance instance : response.getBody().getItems().getDBInstance()) {
                CVMachineInstanceRespDTO.CVMachineInstanceRespDTOBuilder builder = CVMachineInstanceRespDTO.builder().instanceId(instance.getDBInstanceId()).hostname(instance.getEngine()).status(InstanceStatus.valueOf(instance.getDBInstanceStatus())).operateSystem(instance.getEngine() + " " + instance.getEngineVersion()).publicIpAddress(instance.getConnectionString()).machineType(CVSMachineType.RDS).createdTime(DateUtil.format((Date)DateUtil.parse((CharSequence)instance.getCreateTime(), (String)"yyyy-MM-ddTHH:mmZ"), (String)"yyyy-MM-dd HH:mm:ss")).expiredTime(DateUtil.format((Date)DateUtil.parse((CharSequence)instance.getExpireTime(), (String)"yyyy-MM-ddTHH:mmZ"), (String)"yyyy-MM-dd HH:mm:ss"));
                if (!Objects.equals((Object)InstanceStatus.valueOf(instance.getDBInstanceStatus()), (Object)InstanceStatus.Released)) {
                    DescribeRenewalPriceRequest describeRenewalPriceRequest = DescribeRenewalPriceRequest.builder().regionId(regionId).DBInstanceId(instance.getDBInstanceId()).usedTime(Integer.valueOf(1)).timeType("Month").build();
                    DescribeRenewalPriceResponse price = (DescribeRenewalPriceResponse)this.client.describeRenewalPrice(describeRenewalPriceRequest).get();
                    builder.price(new BigDecimal(price.getBody().getPriceInfo().getTradePrice().toString()));
                }
                instances.add(builder.build());
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u963f\u91cc\u4e91ecs\u670d\u52a1\u5668\u5f02\u5e38.", (Throwable)e);
        }
        return instances;
    }
}

