/*
 * Decompiled with CFR 0.152.
 */
package xyz.migoo.framework.cvs.core.client.tencent;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ArrayUtil;
import com.google.common.collect.Lists;
import com.tencentcloudapi.common.Credential;
import com.tencentcloudapi.cvm.v20170312.CvmClient;
import com.tencentcloudapi.cvm.v20170312.models.DescribeInstancesRequest;
import com.tencentcloudapi.cvm.v20170312.models.DescribeInstancesResponse;
import com.tencentcloudapi.cvm.v20170312.models.InquiryPriceRenewInstancesRequest;
import com.tencentcloudapi.cvm.v20170312.models.InquiryPriceRenewInstancesResponse;
import com.tencentcloudapi.cvm.v20170312.models.Instance;
import com.tencentcloudapi.cvm.v20170312.models.RebootInstancesRequest;
import com.tencentcloudapi.cvm.v20170312.models.StartInstancesRequest;
import com.tencentcloudapi.cvm.v20170312.models.StopInstancesRequest;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.migoo.framework.common.pojo.Result;
import xyz.migoo.framework.cvs.core.client.AbstractCVSClient;
import xyz.migoo.framework.cvs.core.client.dto.CVMachineInstanceRespDTO;
import xyz.migoo.framework.cvs.core.client.dto.InstanceStatus;
import xyz.migoo.framework.cvs.core.enums.CVSMachineType;
import xyz.migoo.framework.cvs.core.property.CVSClientProperties;

public class ECSClient
extends AbstractCVSClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ECSClient.class);
    private CvmClient client;

    public ECSClient(CVSClientProperties properties) {
        super(properties);
    }

    @Override
    protected void doInitialization() {
        Credential cred = new Credential(this.properties.getAccessKeyId(), this.properties.getAccessKeySecret());
        this.client = new CvmClient(cred, this.properties.getRegion());
    }

    @Override
    public Result<List<CVMachineInstanceRespDTO>> getInstances(String regionId) {
        return this.getInstances(regionId, null);
    }

    @Override
    public Result<List<CVMachineInstanceRespDTO>> getInstances(String regionId, List<String> instanceIds) {
        DescribeInstancesRequest request = new DescribeInstancesRequest();
        request.setLimit(Long.valueOf(2000L));
        if (Objects.nonNull(instanceIds)) {
            request.setInstanceIds(instanceIds.toArray(new String[0]));
        }
        ArrayList instances = Lists.newArrayList();
        try {
            DescribeInstancesResponse resp = this.client.DescribeInstances(request);
            for (Instance item : resp.getInstanceSet()) {
                CVMachineInstanceRespDTO.CVMachineInstanceRespDTOBuilder builder = CVMachineInstanceRespDTO.builder().instanceId(item.getInstanceId()).hostname(item.getInstanceName()).status(InstanceStatus.valOf(item.getInstanceState())).operateSystem(item.getOsName()).publicIpAddress(ArrayUtil.isEmpty((Object[])item.getPublicIpAddresses()) ? "" : item.getPublicIpAddresses()[0]).privateIpAddress(ArrayUtil.isEmpty((Object[])item.getPrivateIpAddresses()) ? "" : item.getPrivateIpAddresses()[0]).machineType(CVSMachineType.ECS).createdTime(DateUtil.format((Date)DateUtil.parse((CharSequence)item.getCreatedTime(), (String)"yyyy-MM-ddTHH:mmZ"), (String)"yyyy-MM-dd HH:mm:ss")).expiredTime(DateUtil.format((Date)DateUtil.parse((CharSequence)item.getExpiredTime(), (String)"yyyy-MM-ddTHH:mmZ"), (String)"yyyy-MM-dd HH:mm:ss"));
                if (!Objects.equals((Object)InstanceStatus.valOf(item.getInstanceState()), (Object)InstanceStatus.Released)) {
                    InquiryPriceRenewInstancesRequest priceRenewInstancesRequest = new InquiryPriceRenewInstancesRequest();
                    priceRenewInstancesRequest.setInstanceIds(new String[]{item.getInstanceId()});
                    InquiryPriceRenewInstancesResponse price = this.client.InquiryPriceRenewInstances(priceRenewInstancesRequest);
                    builder.price(new BigDecimal(price.getPrice().getInstancePrice().getDiscountPrice().toString()));
                }
                instances.add(builder.build());
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u817e\u8baf\u4e91ECS\u5931\u8d25. ", (Throwable)e);
        }
        return Result.getSuccessful((Object)instances);
    }

    @Override
    public Result<Boolean> start(String instanceId) {
        StartInstancesRequest startInstancesRequest = new StartInstancesRequest();
        startInstancesRequest.setInstanceIds(new String[]{instanceId});
        try {
            this.client.StartInstances(startInstancesRequest);
            return Result.getSuccessful((Object)true);
        }
        catch (Exception e) {
            log.error("\u542f\u52a8\u817e\u8baf\u4e91ECS\u5931\u8d25. ", (Throwable)e);
            return Result.getError((Integer)-1, (String)("\u542f\u52a8\u817e\u8baf\u4e91ECS\u5931\u8d25. " + e.getMessage()));
        }
    }

    @Override
    public Result<Boolean> stop(String instanceId) {
        StopInstancesRequest stopInstancesRequest = new StopInstancesRequest();
        stopInstancesRequest.setInstanceIds(new String[]{instanceId});
        try {
            this.client.StopInstances(stopInstancesRequest);
            return Result.getSuccessful((Object)true);
        }
        catch (Exception e) {
            log.error("\u5173\u95ed\u817e\u8baf\u4e91ECS\u5931\u8d25. ", (Throwable)e);
            return Result.getError((Integer)-1, (String)("\u5173\u95ed\u817e\u8baf\u4e91ECS\u5931\u8d25. " + e.getMessage()));
        }
    }

    @Override
    public Result<Boolean> reboot(String instanceId) {
        RebootInstancesRequest rebootInstancesRequest = new RebootInstancesRequest();
        rebootInstancesRequest.setInstanceIds(new String[]{instanceId});
        try {
            this.client.RebootInstances(rebootInstancesRequest);
            return Result.getSuccessful((Object)true);
        }
        catch (Exception e) {
            log.error("\u91cd\u542f\u817e\u8baf\u4e91ECS\u5931\u8d25. ", (Throwable)e);
            return Result.getError((Integer)-1, (String)("\u91cd\u542f\u817e\u8baf\u4e91ECS\u5931\u8d25. " + e.getMessage()));
        }
    }
}

