/*
 * Decompiled with CFR 0.152.
 */
package xyz.migoo.framework.cvs.core.client.tencent;

import com.google.common.collect.Lists;
import com.tencentcloudapi.cdb.v20170320.CdbClient;
import com.tencentcloudapi.cdb.v20170320.models.DescribeDBInstancesRequest;
import com.tencentcloudapi.cdb.v20170320.models.DescribeDBInstancesResponse;
import com.tencentcloudapi.cdb.v20170320.models.DescribeDBPriceRequest;
import com.tencentcloudapi.cdb.v20170320.models.DescribeDBPriceResponse;
import com.tencentcloudapi.cdb.v20170320.models.InstanceInfo;
import com.tencentcloudapi.cdb.v20170320.models.RestartDBInstancesRequest;
import com.tencentcloudapi.common.Credential;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.migoo.framework.common.pojo.Result;
import xyz.migoo.framework.cvs.core.client.AbstractCVSClient;
import xyz.migoo.framework.cvs.core.client.dto.CVMachineInstanceRespDTO;
import xyz.migoo.framework.cvs.core.client.dto.InstanceStatus;
import xyz.migoo.framework.cvs.core.enums.CVSMachineType;
import xyz.migoo.framework.cvs.core.property.CVSClientProperties;

public class RDSClient
extends AbstractCVSClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RDSClient.class);
    private CdbClient client;

    public RDSClient(CVSClientProperties properties) {
        super(properties);
    }

    @Override
    protected void doInitialization() {
        Credential cred = new Credential(this.properties.getAccessKeyId(), this.properties.getAccessKeySecret());
        this.client = new CdbClient(cred, this.properties.getRegion());
    }

    @Override
    public Result<List<CVMachineInstanceRespDTO>> getInstances(String regionId) {
        return this.getInstances(regionId, null);
    }

    @Override
    public Result<List<CVMachineInstanceRespDTO>> getInstances(String regionId, List<String> instanceIds) {
        DescribeDBInstancesRequest request = new DescribeDBInstancesRequest();
        request.setLimit(Long.valueOf(2000L));
        if (Objects.nonNull(instanceIds)) {
            request.setInstanceIds(instanceIds.toArray(new String[0]));
        }
        ArrayList instances = Lists.newArrayList();
        try {
            DescribeDBInstancesResponse resp = this.client.DescribeDBInstances(request);
            for (InstanceInfo item : resp.getItems()) {
                CVMachineInstanceRespDTO.CVMachineInstanceRespDTOBuilder builder = CVMachineInstanceRespDTO.builder().instanceId(item.getInstanceId()).hostname(item.getInstanceName()).status(InstanceStatus.valOf(item.getStatus().intValue())).operateSystem("MySql " + item.getEngineVersion()).publicIpAddress(item.getWanDomain() + ":" + item.getWanPort()).machineType(CVSMachineType.RDS).createdTime(item.getCreateTime()).expiredTime(item.getDeadlineTime());
                if (!Objects.equals((Object)InstanceStatus.valOf(item.getStatus().intValue()), (Object)InstanceStatus.Released)) {
                    DescribeDBPriceRequest describeDBPriceRequest = new DescribeDBPriceRequest();
                    describeDBPriceRequest.setInstanceId(item.getInstanceId());
                    DescribeDBPriceResponse price = this.client.DescribeDBPrice(describeDBPriceRequest);
                    builder.price(new BigDecimal(price.getPrice()));
                }
                instances.add(builder.build());
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u817e\u8baf\u4e91RDS\u5931\u8d25. ", (Throwable)e);
        }
        return Result.getSuccessful((Object)instances);
    }

    @Override
    public Result<Boolean> start(String instanceId) {
        return Result.getError((Integer)-1, (String)"\u817e\u8baf\u4e91RDS\u4e0d\u652f\u6301\u6b64\u64cd\u4f5c. ");
    }

    @Override
    public Result<Boolean> stop(String instanceId) {
        return Result.getError((Integer)-1, (String)"\u817e\u8baf\u4e91RDS\u4e0d\u652f\u6301\u6b64\u64cd\u4f5c. ");
    }

    @Override
    public Result<Boolean> reboot(String instanceId) {
        RestartDBInstancesRequest request = new RestartDBInstancesRequest();
        request.setInstanceIds(new String[]{instanceId});
        try {
            this.client.RestartDBInstances(request);
            return Result.getSuccessful((Object)true);
        }
        catch (Exception e) {
            log.error("\u91cd\u542f\u817e\u8baf\u4e91RDS\u5931\u8d25. ", (Throwable)e);
            return Result.getError((Integer)-1, (String)("\u91cd\u542f\u817e\u8baf\u4e91RDS\u5931\u8d25. " + e.getMessage()));
        }
    }
}

