/*
 * Decompiled with CFR 0.152.
 */
package xyz.migoo.framework.oss.core.client;

import cn.hutool.core.util.StrUtil;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.migoo.framework.oss.core.client.FileClient;
import xyz.migoo.framework.oss.core.client.FileClientConfig;

public abstract class AbstractFileClient<Config extends FileClientConfig>
implements FileClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractFileClient.class);
    private final Long id;
    protected Config config;

    public AbstractFileClient(Long id, Config config) {
        this.id = id;
        this.config = config;
    }

    public final void init() {
        this.doInit();
        log.debug("[init][\u914d\u7f6e({}) \u521d\u59cb\u5316\u5b8c\u6210]", this.config);
    }

    protected abstract void doInit();

    public final void refresh(Config config) {
        if (config.equals(this.config)) {
            return;
        }
        log.info("[refresh][\u914d\u7f6e({})\u53d1\u751f\u53d8\u5316\uff0c\u91cd\u65b0\u521d\u59cb\u5316]", config);
        this.config = config;
        this.init();
    }

    @Override
    public Long getId() {
        return this.id;
    }

    protected String formatFileUrl(String domain, String path) {
        return StrUtil.format((CharSequence)"{}/{}/{}", (Object[])new Object[]{domain, this.getId(), path});
    }
}

