/*
 * Decompiled with CFR 0.152.
 */
package xyz.migoo.framework.oss.core.client;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ReflectUtil;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.migoo.framework.oss.core.client.AbstractFileClient;
import xyz.migoo.framework.oss.core.client.FileClient;
import xyz.migoo.framework.oss.core.client.FileClientConfig;
import xyz.migoo.framework.oss.core.client.FileClientFactory;
import xyz.migoo.framework.oss.core.enums.FileStorageEnum;

public class FileClientFactoryImpl
implements FileClientFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileClientFactoryImpl.class);
    private final ConcurrentMap<Long, AbstractFileClient<?>> clients = new ConcurrentHashMap();

    @Override
    public FileClient getFileClient(Long configId) {
        AbstractFileClient client = (AbstractFileClient)this.clients.get(configId);
        if (client == null) {
            log.error("[getFileClient][\u914d\u7f6e\u7f16\u53f7({}) \u627e\u4e0d\u5230\u5ba2\u6237\u7aef]", (Object)configId);
        }
        return client;
    }

    @Override
    public <Config extends FileClientConfig> void createOrUpdateFileClient(Long configId, Integer storage, Config config) {
        AbstractFileClient<Config> client = (AbstractFileClient<Config>)this.clients.get(configId);
        if (client == null) {
            client = this.createFileClient(configId, storage, config);
            client.init();
            this.clients.put(client.getId(), client);
        } else {
            client.refresh(config);
        }
    }

    private <Config extends FileClientConfig> AbstractFileClient<Config> createFileClient(Long configId, Integer storage, Config config) {
        FileStorageEnum storageEnum = FileStorageEnum.getByStorage(storage);
        Assert.notNull((Object)((Object)storageEnum), (String)String.format("\u6587\u4ef6\u914d\u7f6e(%s) \u4e3a\u7a7a", new Object[]{storageEnum}), (Object[])new Object[0]);
        return (AbstractFileClient)ReflectUtil.newInstance(storageEnum.getClientClass(), (Object[])new Object[]{configId, config});
    }
}

