/*
 * Decompiled with CFR 0.152.
 */
package xyz.migoo.framework.oss.core.client.db;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.extra.spring.SpringUtil;
import java.util.Comparator;
import java.util.List;
import xyz.migoo.framework.oss.core.client.AbstractFileClient;
import xyz.migoo.framework.oss.core.client.FileContentDTO;
import xyz.migoo.framework.oss.core.client.db.DBFileClientConfig;
import xyz.migoo.framework.oss.core.client.db.IFileContentMapper;

public class DBFileClient
extends AbstractFileClient<DBFileClientConfig> {
    private IFileContentMapper fileContentMapper;

    public DBFileClient(Long id, DBFileClientConfig config) {
        super(id, config);
    }

    @Override
    protected void doInit() {
        this.fileContentMapper = (IFileContentMapper)SpringUtil.getBean(IFileContentMapper.class);
    }

    @Override
    public String upload(byte[] content, String path, String type) {
        this.fileContentMapper.insert(content, path, type, this.getId());
        return super.formatFileUrl(((DBFileClientConfig)this.config).getDomain(), path);
    }

    @Override
    public void delete(String path) {
        this.fileContentMapper.deleteByConfigIdAndPath(this.getId(), path);
    }

    @Override
    public byte[] getContent(String path) {
        List<FileContentDTO> list = this.fileContentMapper.selectListByConfigIdAndPath(this.getId(), path);
        if (CollUtil.isEmpty(list)) {
            return null;
        }
        list.sort(Comparator.comparing(FileContentDTO::getId));
        return ((FileContentDTO)CollUtil.getLast(list)).getContent();
    }
}

