/*
 * Decompiled with CFR 0.152.
 */
package xyz.migoo.framework.oss.core.client.s3;

import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import io.minio.GetObjectArgs;
import io.minio.GetObjectResponse;
import io.minio.GetPresignedObjectUrlArgs;
import io.minio.MinioClient;
import io.minio.PutObjectArgs;
import io.minio.RemoveObjectArgs;
import io.minio.http.Method;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import xyz.migoo.framework.oss.core.client.AbstractFileClient;
import xyz.migoo.framework.oss.core.client.s3.FilePresignedUrlRespDTO;
import xyz.migoo.framework.oss.core.client.s3.S3FileClientConfig;

public class S3FileClient
extends AbstractFileClient<S3FileClientConfig> {
    private MinioClient client;

    public S3FileClient(Long id, S3FileClientConfig config) {
        super(id, config);
    }

    @Override
    protected void doInit() {
        if (StrUtil.isEmpty((CharSequence)((S3FileClientConfig)this.config).getDomain())) {
            ((S3FileClientConfig)this.config).setDomain(this.buildDomain());
        }
        this.client = MinioClient.builder().endpoint(this.buildEndpointURL()).region(this.buildRegion()).credentials(((S3FileClientConfig)this.config).getAccessKey(), ((S3FileClientConfig)this.config).getAccessSecret()).build();
    }

    private String buildEndpointURL() {
        if (HttpUtil.isHttp((String)((S3FileClientConfig)this.config).getEndpoint()) || HttpUtil.isHttps((String)((S3FileClientConfig)this.config).getEndpoint())) {
            return ((S3FileClientConfig)this.config).getEndpoint();
        }
        return StrUtil.format((CharSequence)"https://{}", (Object[])new Object[]{((S3FileClientConfig)this.config).getEndpoint()});
    }

    private String buildDomain() {
        if (HttpUtil.isHttp((String)((S3FileClientConfig)this.config).getEndpoint()) || HttpUtil.isHttps((String)((S3FileClientConfig)this.config).getEndpoint())) {
            return StrUtil.format((CharSequence)"{}/{}", (Object[])new Object[]{((S3FileClientConfig)this.config).getEndpoint(), ((S3FileClientConfig)this.config).getBucket()});
        }
        return StrUtil.format((CharSequence)"https://{}.{}", (Object[])new Object[]{((S3FileClientConfig)this.config).getBucket(), ((S3FileClientConfig)this.config).getEndpoint()});
    }

    private String buildRegion() {
        if (((S3FileClientConfig)this.config).getEndpoint().contains("aliyuncs.com")) {
            return StrUtil.subBefore((CharSequence)((S3FileClientConfig)this.config).getEndpoint(), (char)'.', (boolean)false).replaceAll("-internal", "").replaceAll("https://", "");
        }
        if (((S3FileClientConfig)this.config).getEndpoint().contains("myqcloud.com")) {
            return StrUtil.subAfter((CharSequence)((S3FileClientConfig)this.config).getEndpoint(), (CharSequence)"cos.", (boolean)false).replaceAll(".myqcloud.com", "");
        }
        return null;
    }

    @Override
    public String upload(byte[] content, String path, String type) throws Exception {
        this.client.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(((S3FileClientConfig)this.config).getBucket())).contentType(type).object(path)).stream((InputStream)new ByteArrayInputStream(content), (long)content.length, -1L).build());
        return ((S3FileClientConfig)this.config).getDomain() + "/" + path;
    }

    @Override
    public void delete(String path) throws Exception {
        this.client.removeObject((RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(((S3FileClientConfig)this.config).getBucket())).object(path)).build());
    }

    @Override
    public byte[] getContent(String path) throws Exception {
        GetObjectResponse response = this.client.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(((S3FileClientConfig)this.config).getBucket())).object(path)).build());
        return IoUtil.readBytes((InputStream)response);
    }

    @Override
    public FilePresignedUrlRespDTO getPresignedObjectUrl(String path) throws Exception {
        String uploadUrl = this.client.getPresignedObjectUrl((GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().method(Method.PUT).bucket(((S3FileClientConfig)this.config).getBucket())).object(path)).expiry(10, TimeUnit.MINUTES).build());
        return new FilePresignedUrlRespDTO(uploadUrl, ((S3FileClientConfig)this.config).getDomain() + "/" + path);
    }
}

