/*
 * Decompiled with CFR 0.152.
 */
package xyz.migoo.framework.oss.core.enums;

import cn.hutool.core.util.ArrayUtil;
import lombok.Generated;
import xyz.migoo.framework.oss.core.client.FileClient;
import xyz.migoo.framework.oss.core.client.FileClientConfig;
import xyz.migoo.framework.oss.core.client.db.DBFileClient;
import xyz.migoo.framework.oss.core.client.db.DBFileClientConfig;
import xyz.migoo.framework.oss.core.client.local.LocalFileClient;
import xyz.migoo.framework.oss.core.client.local.LocalFileClientConfig;
import xyz.migoo.framework.oss.core.client.s3.S3FileClient;
import xyz.migoo.framework.oss.core.client.s3.S3FileClientConfig;

public enum FileStorageEnum {
    DB(1, DBFileClientConfig.class, DBFileClient.class),
    LOCAL(10, LocalFileClientConfig.class, LocalFileClient.class),
    S3(20, S3FileClientConfig.class, S3FileClient.class);

    private final Integer storage;
    private final Class<? extends FileClientConfig> configClass;
    private final Class<? extends FileClient> clientClass;

    public static FileStorageEnum getByStorage(Integer storage) {
        return (FileStorageEnum)((Object)ArrayUtil.firstMatch(o -> o.getStorage().equals(storage), (Object[])FileStorageEnum.values()));
    }

    @Generated
    private FileStorageEnum(Integer storage, Class<? extends FileClientConfig> configClass, Class<? extends FileClient> clientClass) {
        this.storage = storage;
        this.configClass = configClass;
        this.clientClass = clientClass;
    }

    @Generated
    public Integer getStorage() {
        return this.storage;
    }

    @Generated
    public Class<? extends FileClientConfig> getConfigClass() {
        return this.configClass;
    }

    @Generated
    public Class<? extends FileClient> getClientClass() {
        return this.clientClass;
    }
}

