/*
 * Decompiled with CFR 0.152.
 */
package xyz.migoo.framework.web.config;

import jakarta.annotation.Resource;
import jakarta.servlet.Filter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;
import org.springframework.web.servlet.config.annotation.PathMatchConfigurer;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import xyz.migoo.framework.apilog.core.ApiErrorLogFrameworkService;
import xyz.migoo.framework.web.config.WebProperties;
import xyz.migoo.framework.web.config.XssProperties;
import xyz.migoo.framework.web.core.filter.CacheRequestBodyFilter;
import xyz.migoo.framework.web.core.filter.XssFilter;
import xyz.migoo.framework.web.core.handler.GlobalExceptionHandler;
import xyz.migoo.framework.web.core.handler.GlobalResponseBodyHandler;

@Configuration
@EnableConfigurationProperties(value={WebProperties.class, XssProperties.class})
public class MiGooWebAutoConfiguration
implements WebMvcConfigurer {
    @Resource
    private WebProperties webProperties;
    @Value(value="${spring.application.name}")
    private String applicationName;

    private static <T extends Filter> FilterRegistrationBean<T> createFilterBean(T filter, Integer order) {
        FilterRegistrationBean bean = new FilterRegistrationBean(filter, new ServletRegistrationBean[0]);
        bean.setOrder(order.intValue());
        return bean;
    }

    public void configurePathMatch(PathMatchConfigurer configurer) {
        AntPathMatcher antPathMatcher = new AntPathMatcher(".");
        configurer.addPathPrefix(this.webProperties.getApiPrefix(), clazz -> this.webProperties.isOnlyRest() ? clazz.isAnnotationPresent(RestController.class) && antPathMatcher.match(this.webProperties.getControllerPackage(), clazz.getPackage().getName()) : antPathMatcher.match(this.webProperties.getControllerPackage(), clazz.getPackage().getName()));
    }

    @Bean
    public GlobalExceptionHandler globalExceptionHandler(ApiErrorLogFrameworkService apiErrorLogFrameworkService) {
        return new GlobalExceptionHandler(this.applicationName, apiErrorLogFrameworkService);
    }

    @Bean
    public GlobalResponseBodyHandler globalResponseBodyHandler() {
        return new GlobalResponseBodyHandler();
    }

    @Bean
    public FilterRegistrationBean<CorsFilter> corsFilterBean() {
        CorsConfiguration config = new CorsConfiguration();
        config.setAllowCredentials(Boolean.valueOf(true));
        config.addAllowedOriginPattern("*");
        config.addAllowedHeader("*");
        config.addAllowedMethod("*");
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        source.registerCorsConfiguration("/**", config);
        return MiGooWebAutoConfiguration.createFilterBean(new CorsFilter((CorsConfigurationSource)source), Integer.MIN_VALUE);
    }

    @Bean
    public FilterRegistrationBean<CacheRequestBodyFilter> requestBodyCacheFilter() {
        return MiGooWebAutoConfiguration.createFilterBean(new CacheRequestBodyFilter(), -2147483148);
    }

    @Bean
    public FilterRegistrationBean<XssFilter> xssFilter(XssProperties properties, PathMatcher pathMatcher) {
        return MiGooWebAutoConfiguration.createFilterBean(new XssFilter(properties, pathMatcher), -103);
    }
}

