/*
 * Decompiled with CFR 0.152.
 */
package xyz.migoo.framework.web.core.filter;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.util.PathMatcher;
import org.springframework.web.filter.OncePerRequestFilter;
import xyz.migoo.framework.web.config.XssProperties;
import xyz.migoo.framework.web.core.filter.XssRequestWrapper;

public class XssFilter
extends OncePerRequestFilter {
    private final XssProperties properties;
    private final PathMatcher pathMatcher;

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        filterChain.doFilter((ServletRequest)new XssRequestWrapper(request), (ServletResponse)response);
    }

    protected boolean shouldNotFilter(HttpServletRequest request) {
        if (!this.properties.isEnable()) {
            return true;
        }
        String uri = request.getRequestURI();
        return this.properties.getExcludeUrls().stream().anyMatch(excludeUrl -> this.pathMatcher.match(excludeUrl, uri));
    }

    public XssFilter(XssProperties properties, PathMatcher pathMatcher) {
        this.properties = properties;
        this.pathMatcher = pathMatcher;
    }
}

