/*
 * Decompiled with CFR 0.152.
 */
package xyz.migoo.framework.web.core.handler;

import cn.hutool.core.exceptions.ExceptionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.socket.SocketRuntimeException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.ValidationException;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;
import org.springframework.web.servlet.NoHandlerFoundException;
import xyz.migoo.framework.apilog.core.ApiErrorLog;
import xyz.migoo.framework.apilog.core.ApiErrorLogFrameworkService;
import xyz.migoo.framework.common.exception.ErrorCode;
import xyz.migoo.framework.common.exception.ServiceException;
import xyz.migoo.framework.common.exception.enums.GlobalErrorCodeConstants;
import xyz.migoo.framework.common.pojo.Result;
import xyz.migoo.framework.common.util.json.JsonUtils;
import xyz.migoo.framework.common.util.servlet.ServletUtils;

@RestControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);
    private final String applicationName;
    private final ApiErrorLogFrameworkService apiErrorLogFrameworkService;

    public Result<?> allExceptionHandler(HttpServletRequest request, Throwable t) {
        if (t instanceof HttpMediaTypeNotSupportedException) {
            HttpMediaTypeNotSupportedException th = (HttpMediaTypeNotSupportedException)t;
            return this.httpMediaTypeNotSupportedException(request, th);
        }
        if (t instanceof MissingServletRequestParameterException) {
            MissingServletRequestParameterException th = (MissingServletRequestParameterException)t;
            return this.missingServletRequestParameterExceptionHandler(request, th);
        }
        if (t instanceof MethodArgumentTypeMismatchException) {
            MethodArgumentTypeMismatchException th = (MethodArgumentTypeMismatchException)t;
            return this.methodArgumentTypeMismatchExceptionHandler(request, th);
        }
        if (t instanceof MethodArgumentNotValidException) {
            MethodArgumentNotValidException th = (MethodArgumentNotValidException)t;
            return this.methodArgumentNotValidExceptionExceptionHandler(request, th);
        }
        if (t instanceof BindException) {
            BindException th = (BindException)t;
            return this.bindExceptionHandler(request, th);
        }
        if (t instanceof ConstraintViolationException) {
            ConstraintViolationException th = (ConstraintViolationException)t;
            return this.constraintViolationExceptionHandler(request, th);
        }
        if (t instanceof ValidationException) {
            ValidationException th = (ValidationException)t;
            return this.validationException(request, th);
        }
        if (t instanceof NoHandlerFoundException) {
            NoHandlerFoundException th = (NoHandlerFoundException)t;
            return this.noHandlerFoundExceptionHandler(request, th);
        }
        if (t instanceof HttpRequestMethodNotSupportedException) {
            HttpRequestMethodNotSupportedException th = (HttpRequestMethodNotSupportedException)t;
            return this.httpRequestMethodNotSupportedExceptionHandler(request, th);
        }
        if (t instanceof ServiceException) {
            ServiceException th = (ServiceException)t;
            return this.serviceExceptionHandler(request, th);
        }
        return this.defaultExceptionHandler(request, t);
    }

    @ExceptionHandler(value={HttpMediaTypeNotSupportedException.class})
    @ResponseBody
    public Result<?> httpMediaTypeNotSupportedException(HttpServletRequest request, HttpMediaTypeNotSupportedException t) {
        String msg = ErrorCode.getLocalMessage((Integer)GlobalErrorCodeConstants.BAD_REQUEST.getCode(), (HttpServletRequest)request);
        return Result.getError((Integer)GlobalErrorCodeConstants.BAD_REQUEST.getCode(), (String)String.format("%s:%s", msg, t.getContentType()));
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    public Result<?> missingServletRequestParameterExceptionHandler(HttpServletRequest request, MissingServletRequestParameterException ex) {
        String msg = ErrorCode.getLocalMessage((Integer)GlobalErrorCodeConstants.BAD_REQUEST.getCode(), (HttpServletRequest)request);
        return Result.getError((Integer)GlobalErrorCodeConstants.BAD_REQUEST.getCode(), (String)String.format("%s:%s", msg, ex.getParameterName()));
    }

    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class})
    public Result<?> methodArgumentTypeMismatchExceptionHandler(HttpServletRequest request, MethodArgumentTypeMismatchException ex) {
        String msg = ErrorCode.getLocalMessage((Integer)GlobalErrorCodeConstants.BAD_REQUEST.getCode(), (HttpServletRequest)request);
        return Result.getError((Integer)GlobalErrorCodeConstants.BAD_REQUEST.getCode(), (String)String.format("%s:%s", msg, ex.getMessage()));
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public Result<?> methodArgumentNotValidExceptionExceptionHandler(HttpServletRequest request, MethodArgumentNotValidException ex) {
        FieldError fieldError = ex.getBindingResult().getFieldError();
        assert (fieldError != null);
        String msg = ErrorCode.getLocalMessage((Integer)GlobalErrorCodeConstants.BAD_REQUEST.getCode(), (HttpServletRequest)request);
        return Result.getError((Integer)GlobalErrorCodeConstants.BAD_REQUEST.getCode(), (String)String.format("%s:%s", msg, fieldError.getDefaultMessage()));
    }

    @ExceptionHandler(value={BindException.class})
    public Result<?> bindExceptionHandler(HttpServletRequest request, BindException ex) {
        FieldError fieldError = ex.getFieldError();
        assert (fieldError != null);
        String msg = ErrorCode.getLocalMessage((Integer)GlobalErrorCodeConstants.BAD_REQUEST.getCode(), (HttpServletRequest)request);
        return Result.getError((Integer)GlobalErrorCodeConstants.BAD_REQUEST.getCode(), (String)String.format("%s:%s", msg, fieldError.getDefaultMessage()));
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    public Result<?> constraintViolationExceptionHandler(HttpServletRequest request, ConstraintViolationException ex) {
        ConstraintViolation constraintViolation = (ConstraintViolation)ex.getConstraintViolations().iterator().next();
        String msg = ErrorCode.getLocalMessage((Integer)GlobalErrorCodeConstants.BAD_REQUEST.getCode(), (HttpServletRequest)request);
        return Result.getError((Integer)GlobalErrorCodeConstants.BAD_REQUEST.getCode(), (String)String.format("%s:%s", msg, constraintViolation.getMessage()));
    }

    @ExceptionHandler(value={ValidationException.class})
    public Result<?> validationException(HttpServletRequest request, ValidationException ex) {
        return Result.getError((Integer)GlobalErrorCodeConstants.BAD_REQUEST.getCode(), (String)GlobalErrorCodeConstants.BAD_REQUEST.getMessage(request));
    }

    @ExceptionHandler(value={NoHandlerFoundException.class})
    public Result<?> noHandlerFoundExceptionHandler(HttpServletRequest request, NoHandlerFoundException ex) {
        String msg = ErrorCode.getLocalMessage((Integer)GlobalErrorCodeConstants.NOT_FOUND.getCode(), (HttpServletRequest)request);
        return Result.getError((Integer)GlobalErrorCodeConstants.NOT_FOUND.getCode(), (String)String.format("%s:%s", msg, ex.getRequestURL()));
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public Result<?> httpRequestMethodNotSupportedExceptionHandler(HttpServletRequest request, HttpRequestMethodNotSupportedException ex) {
        String msg = ErrorCode.getLocalMessage((Integer)GlobalErrorCodeConstants.METHOD_NOT_ALLOWED.getCode(), (HttpServletRequest)request);
        return Result.getError((Integer)GlobalErrorCodeConstants.METHOD_NOT_ALLOWED.getCode(), (String)String.format("%s:%s", msg, ex.getMethod()));
    }

    @ExceptionHandler(value={SocketRuntimeException.class})
    public Result<?> socketRuntimeExceptionHandler(HttpServletRequest request, SocketRuntimeException ex) {
        return Result.getError((Integer)GlobalErrorCodeConstants.SOCKET_TIME_OUT.getCode(), (String)GlobalErrorCodeConstants.SOCKET_TIME_OUT.getMessage(request));
    }

    @ExceptionHandler(value={ServiceException.class})
    public Result<?> serviceExceptionHandler(HttpServletRequest request, ServiceException ex) {
        return Result.getError((Integer)ex.getCode(), (String)ErrorCode.getLocalMessage((Integer)ex.getCode(), (HttpServletRequest)request));
    }

    @ExceptionHandler(value={Exception.class})
    public Result<?> defaultExceptionHandler(HttpServletRequest request, Throwable ex) {
        this.createExceptionLog(request, ex);
        log.error(ex.getMessage(), ex);
        return Result.getError((Integer)GlobalErrorCodeConstants.INTERNAL_SERVER_ERROR.getCode(), (String)GlobalErrorCodeConstants.INTERNAL_SERVER_ERROR.getMessage(request));
    }

    private void createExceptionLog(HttpServletRequest request, Throwable e) {
        ApiErrorLog errorLog = new ApiErrorLog();
        try {
            this.initExceptionLog(errorLog, request, e);
            this.apiErrorLogFrameworkService.createApiErrorLog(errorLog);
        }
        catch (Throwable th) {
            log.error("[createExceptionLog][url({}) log({}) \u53d1\u751f\u5f02\u5e38]", new Object[]{request.getRequestURI(), JsonUtils.toJsonString((Object)errorLog), th});
        }
    }

    private void initExceptionLog(ApiErrorLog errorLog, HttpServletRequest request, Throwable e) {
        errorLog.setExceptionName(e.getClass().getName());
        errorLog.setExceptionMessage(ExceptionUtil.getMessage((Throwable)e));
        errorLog.setExceptionRootCauseMessage(ExceptionUtil.getRootCauseMessage((Throwable)e));
        errorLog.setExceptionStackTrace(ExceptionUtil.stacktraceToString((Throwable)e));
        Object[] stackTraceElements = e.getStackTrace();
        Assert.notEmpty((Object[])stackTraceElements, (String)"\u5f02\u5e38 stackTraceElements \u4e0d\u80fd\u4e3a\u7a7a");
        Object stackTraceElement = stackTraceElements[0];
        errorLog.setExceptionClassName(((StackTraceElement)stackTraceElement).getClassName());
        errorLog.setExceptionFileName(((StackTraceElement)stackTraceElement).getFileName());
        errorLog.setExceptionMethodName(((StackTraceElement)stackTraceElement).getMethodName());
        errorLog.setExceptionLineNumber(((StackTraceElement)stackTraceElement).getLineNumber());
        errorLog.setApplicationName(this.applicationName);
        errorLog.setRequestUrl(request.getRequestURI());
        Map requestParams = MapUtil.builder().put((Object)"query", (Object)ServletUtils.getParamMap((ServletRequest)request)).put((Object)"body", (Object)ServletUtils.getBody((ServletRequest)request)).build();
        errorLog.setRequestParams(JsonUtils.toJsonString((Object)requestParams));
        errorLog.setRequestMethod(request.getMethod());
        errorLog.setUserIp(ServletUtils.getClientIP((HttpServletRequest)request, (String[])new String[0]));
        errorLog.setExceptionTime(new Date());
    }

    public GlobalExceptionHandler(String applicationName, ApiErrorLogFrameworkService apiErrorLogFrameworkService) {
        this.applicationName = applicationName;
        this.apiErrorLogFrameworkService = apiErrorLogFrameworkService;
    }
}

