/*
 * Decompiled with CFR 0.152.
 */
package xyz.migoo.framework.web.core.util;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import xyz.migoo.framework.common.pojo.Result;

public class WebFrameworkUtils {
    private static final String REQUEST_ATTRIBUTE_LOGIN_USER_ID = "login_user_id";
    private static final String REQUEST_ATTRIBUTE_LOGIN_USER_NAME = "login_user_name";
    private static final String REQUEST_ATTRIBUTE_RESULT = "result";

    public static void setLoginUserId(ServletRequest request, Long userId) {
        request.setAttribute(REQUEST_ATTRIBUTE_LOGIN_USER_ID, (Object)userId);
    }

    public static void setLoginUserName(ServletRequest request, String compoundName) {
        request.setAttribute(REQUEST_ATTRIBUTE_LOGIN_USER_NAME, (Object)compoundName);
    }

    public static Long getLoginUserId(HttpServletRequest request) {
        if (request == null) {
            return null;
        }
        return (Long)request.getAttribute(REQUEST_ATTRIBUTE_LOGIN_USER_ID);
    }

    public static String getLoginUserName(HttpServletRequest request) {
        if (request == null) {
            return null;
        }
        return (String)request.getAttribute(REQUEST_ATTRIBUTE_LOGIN_USER_NAME);
    }

    public static Long getLoginUserId() {
        HttpServletRequest request = WebFrameworkUtils.getRequest();
        return WebFrameworkUtils.getLoginUserId(request);
    }

    public static String getLoginUserName() {
        HttpServletRequest request = WebFrameworkUtils.getRequest();
        return WebFrameworkUtils.getLoginUserName(request);
    }

    public static void setResult(ServletRequest request, Result<?> result) {
        request.setAttribute(REQUEST_ATTRIBUTE_RESULT, result);
    }

    public static Result<?> getCommonResult(ServletRequest request) {
        return (Result)request.getAttribute(REQUEST_ATTRIBUTE_RESULT);
    }

    private static HttpServletRequest getRequest() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (!(requestAttributes instanceof ServletRequestAttributes)) {
            return null;
        }
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)requestAttributes;
        return servletRequestAttributes.getRequest();
    }
}

