/*
 * Decompiled with CFR 0.152.
 */
package xyz.migoo.framework.infra.controller.login;

import cn.hutool.crypto.SecureUtil;
import cn.hutool.extra.qrcode.QrCodeUtil;
import cn.hutool.extra.qrcode.QrConfig;
import jakarta.annotation.Resource;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;
import xyz.migoo.framework.common.enums.CommonStatus;
import xyz.migoo.framework.common.exception.ErrorCode;
import xyz.migoo.framework.common.exception.util.ServiceExceptionUtil;
import xyz.migoo.framework.common.pojo.Result;
import xyz.migoo.framework.common.util.collection.SetUtils;
import xyz.migoo.framework.infra.controller.login.vo.AuthLoginReqVO;
import xyz.migoo.framework.infra.controller.login.vo.AuthLoginRespVO;
import xyz.migoo.framework.infra.controller.login.vo.AuthMenuRespVO;
import xyz.migoo.framework.infra.controller.login.vo.PasswordVO;
import xyz.migoo.framework.infra.convert.AuthConvert;
import xyz.migoo.framework.infra.dal.dataobject.sys.ConfigurerDO;
import xyz.migoo.framework.infra.dal.dataobject.sys.Menu;
import xyz.migoo.framework.infra.dal.dataobject.sys.User;
import xyz.migoo.framework.infra.enums.MenuTypeEnum;
import xyz.migoo.framework.infra.enums.SysErrorCodeConstants;
import xyz.migoo.framework.infra.service.login.TokenService;
import xyz.migoo.framework.infra.service.sys.configurer.ConfigurerService;
import xyz.migoo.framework.infra.service.sys.permission.PermissionService;
import xyz.migoo.framework.infra.service.sys.user.UserService;
import xyz.migoo.framework.security.config.SecurityProperties;
import xyz.migoo.framework.security.core.BaseUser;
import xyz.migoo.framework.security.core.LoginUser;
import xyz.migoo.framework.security.core.annotation.Authenticator;
import xyz.migoo.framework.security.core.annotation.CurrentUser;

@RestController
public class LoginController {
    public String title = "";
    @Resource
    private TokenService tokenService;
    @Resource
    private UserService userService;
    @Resource
    private PermissionService permissionService;
    @Resource
    private SecurityProperties securityProperties;
    @Resource
    private ConfigurerService configurerService;

    @PostMapping(value={"/login"})
    public Result<AuthLoginRespVO> login(@RequestBody AuthLoginReqVO req) {
        return Result.getSuccessful((Object)this.tokenService.signIn(req));
    }

    @GetMapping(value={"/user-info"})
    public Result<?> getUserInfo(@CurrentUser LoginUser loginUser) {
        User user = this.userService.get(loginUser.getId());
        Set<Long> roleIds = this.permissionService.getUserRoleIds((Long)user.getId(), SetUtils.asSet((Object[])new Integer[]{CommonStatus.enabled.status()}));
        List<Menu> menuList = this.permissionService.getRoleMenusFromCache(roleIds, SetUtils.asSet((Object[])new Integer[]{MenuTypeEnum.DIR.getType(), MenuTypeEnum.MENU.getType(), MenuTypeEnum.BUTTON.getType()}), SetUtils.asSet((Object[])new Integer[]{CommonStatus.enabled.status()}));
        return Result.getSuccessful((Object)AuthConvert.INSTANCE.convert((BaseUser<Long>)user, menuList));
    }

    @GetMapping(value={"/configurer"})
    public Result<?> getConfig() {
        Map<String, String> result = this.configurerService.getList().stream().collect(Collectors.toMap(ConfigurerDO::getName, ConfigurerDO::getValue));
        this.title = result.get("title");
        result.put("kit", this.securityProperties.getPasswordSecret());
        return Result.getSuccessful(result);
    }

    @GetMapping(value={"user-menus"})
    public Result<List<AuthMenuRespVO>> getMenus(@CurrentUser LoginUser loginUser) {
        Set<Long> roleIds = this.permissionService.getUserRoleIds(loginUser.getId(), SetUtils.asSet((Object[])new Integer[]{CommonStatus.enabled.status()}));
        List<Menu> menuList = this.permissionService.getRoleMenusFromCache(roleIds, SetUtils.asSet((Object[])new Integer[]{MenuTypeEnum.DIR.getType(), MenuTypeEnum.MENU.getType()}), SetUtils.asSet((Object[])new Integer[]{CommonStatus.enabled.status()}));
        return Result.getSuccessful(AuthConvert.INSTANCE.convert(menuList));
    }

    @GetMapping(value={"/authenticator"})
    public Result<?> getAuthenticator(@CurrentUser LoginUser user) {
        HashMap<String, String> result = new HashMap<String, String>(2);
        String content = String.format("otpauth://totp/%s@%s?secret=%s&issuer=%s", user.getUsername(), user.getName(), user.getSecurityCode(), this.title);
        result.put("quickMark", QrCodeUtil.generateAsBase64((String)content, (QrConfig)new QrConfig(), (String)"png"));
        result.put("securityCode", user.getSecurityCode());
        return Result.getSuccessful(result);
    }

    @PostMapping(value={"/authenticator"})
    @Authenticator
    public Result<?> bindAuthenticator(@CurrentUser LoginUser user) {
        this.userService.update((User)new User().setBindAuthenticator(CommonStatus.enabled.status()).setId(user.getId()));
        return Result.getSuccessful();
    }

    @PostMapping(value={"/password"})
    @Authenticator
    public Result<?> updatePassword(@CurrentUser LoginUser user, @RequestBody PasswordVO password) {
        if (Objects.equals(password.getNewPassword(), password.getOldPassword())) {
            throw ServiceExceptionUtil.get((ErrorCode)SysErrorCodeConstants.USER_PASSWORD_OLD_NEW);
        }
        password.setNewPassword(SecureUtil.aes((byte[])this.securityProperties.getPasswordSecret().getBytes(StandardCharsets.UTF_8)).decryptStr(password.getNewPassword()));
        password.setOldPassword(SecureUtil.aes((byte[])this.securityProperties.getPasswordSecret().getBytes(StandardCharsets.UTF_8)).decryptStr(password.getOldPassword()));
        password.setId(user.getId());
        this.userService.update(password);
        return Result.getSuccessful();
    }
}

