/*
 * Decompiled with CFR 0.152.
 */
package xyz.migoo.framework.infra.controller.sys.configurer;

import jakarta.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import xyz.migoo.framework.common.pojo.Result;
import xyz.migoo.framework.infra.controller.sys.configurer.vo.RequestBodyVO;
import xyz.migoo.framework.infra.convert.sys.ConfigurerConvert;
import xyz.migoo.framework.infra.service.sys.configurer.ConfigurerService;

@RestController
@RequestMapping(value={"/configurer"})
public class ConfigurerController {
    @Resource
    private ConfigurerService service;

    @PutMapping
    @PreAuthorize(value="@ss.hasPermission('system:configurer:update')")
    public Result<?> save(@RequestBody RequestBodyVO req) {
        this.service.save(ConfigurerConvert.INSTANCE.convert(req));
        return Result.getSuccessful();
    }

    @GetMapping(value={"/page"})
    public Result<?> getAll() {
        List<RequestBodyVO> results = ConfigurerConvert.INSTANCE.convert(this.service.getList());
        return Result.getSuccessful(results.stream().collect(Collectors.toMap(RequestBodyVO::getName, item -> item)));
    }
}

