/*
 * Decompiled with CFR 0.152.
 */
package xyz.migoo.framework.infra.controller.sys.dept;

import jakarta.annotation.Resource;
import java.util.Comparator;
import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import xyz.migoo.framework.common.enums.CommonStatus;
import xyz.migoo.framework.common.pojo.Result;
import xyz.migoo.framework.infra.controller.sys.dept.vo.DeptAddReqVO;
import xyz.migoo.framework.infra.controller.sys.dept.vo.DeptQueryReqVO;
import xyz.migoo.framework.infra.controller.sys.dept.vo.DeptRespVO;
import xyz.migoo.framework.infra.controller.sys.dept.vo.DeptSimpleRespVO;
import xyz.migoo.framework.infra.controller.sys.dept.vo.DeptUpdateReqVO;
import xyz.migoo.framework.infra.convert.sys.DeptConvert;
import xyz.migoo.framework.infra.dal.dataobject.sys.Dept;
import xyz.migoo.framework.infra.service.sys.dept.DeptService;

@RestController
@RequestMapping(value={"/dept"})
public class DeptController {
    @Resource
    private DeptService deptService;

    @GetMapping
    @PreAuthorize(value="@ss.hasPermission('system:dept:query')")
    public Result<List<DeptRespVO>> getDeptPage(DeptQueryReqVO req) {
        List<Dept> list = this.deptService.getList(req);
        list.sort(Comparator.comparing(Dept::getSort));
        return Result.getSuccessful(DeptConvert.INSTANCE.convert(list));
    }

    @PostMapping
    @PreAuthorize(value="@ss.hasPermission('system:dept:add')")
    public Result<?> addDept(@RequestBody DeptAddReqVO addReq) {
        this.deptService.verify(null, addReq.getParentId(), addReq.getName());
        this.deptService.add(DeptConvert.INSTANCE.convert(addReq));
        return Result.getSuccessful();
    }

    @PutMapping
    @PreAuthorize(value="@ss.hasPermission('system:dept:update')")
    public Result<?> updateDept(@RequestBody DeptUpdateReqVO updateReqVO) {
        this.deptService.verify(updateReqVO.getId(), updateReqVO.getParentId(), updateReqVO.getName());
        this.deptService.update(DeptConvert.INSTANCE.convert(updateReqVO));
        return Result.getSuccessful();
    }

    @GetMapping(value={"/{id}"})
    @PreAuthorize(value="@ss.hasPermission('system:dept:update')")
    public Result<?> getDept(@PathVariable(value="id") Long id) {
        return Result.getSuccessful((Object)DeptConvert.INSTANCE.convert(this.deptService.get(id)));
    }

    @DeleteMapping(value={"/{id}"})
    @PreAuthorize(value="@ss.hasPermission('system:dept:remove')")
    public Result<?> removeDept(@PathVariable(value="id") Long id) {
        this.deptService.remove(id);
        return Result.getSuccessful();
    }

    @GetMapping(value={"/simple"})
    public Result<List<DeptSimpleRespVO>> getDeptSimple(DeptQueryReqVO req) {
        req.setStatus(CommonStatus.enabled.status());
        List<Dept> list = this.deptService.getList(req);
        list.sort(Comparator.comparing(Dept::getSort));
        return Result.getSuccessful(DeptConvert.INSTANCE.convert0(list));
    }
}

