/*
 * Decompiled with CFR 0.152.
 */
package xyz.migoo.framework.infra.controller.sys.permission.menu;

import jakarta.annotation.Resource;
import jakarta.validation.Valid;
import java.util.Comparator;
import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import xyz.migoo.framework.common.enums.CommonStatus;
import xyz.migoo.framework.common.pojo.Result;
import xyz.migoo.framework.infra.controller.sys.permission.menu.vo.MenuAddReqVO;
import xyz.migoo.framework.infra.controller.sys.permission.menu.vo.MenuQueryReqVO;
import xyz.migoo.framework.infra.controller.sys.permission.menu.vo.MenuRespVO;
import xyz.migoo.framework.infra.controller.sys.permission.menu.vo.MenuSimpleRespVO;
import xyz.migoo.framework.infra.controller.sys.permission.menu.vo.MenuUpdateReqVO;
import xyz.migoo.framework.infra.convert.sys.MenuConvert;
import xyz.migoo.framework.infra.dal.dataobject.sys.Menu;
import xyz.migoo.framework.infra.service.sys.permission.MenuService;

@RestController
@RequestMapping(value={"/menu"})
public class MenuController {
    @Resource
    private MenuService menuService;

    @GetMapping
    @PreAuthorize(value="@ss.hasPermission('system:menu:query')")
    public Result<List<MenuRespVO>> getMenus(MenuQueryReqVO reqVO) {
        List<Menu> list = this.menuService.get(reqVO);
        list.sort(Comparator.comparing(Menu::getSort));
        return Result.getSuccessful(MenuConvert.INSTANCE.convert(list));
    }

    @PostMapping
    @PreAuthorize(value="@ss.hasPermission('system:menu:add')")
    public Result<?> createMenu(@Valid @RequestBody MenuAddReqVO reqVO) {
        this.menuService.add(MenuConvert.INSTANCE.convert(reqVO));
        return Result.getSuccessful();
    }

    @PutMapping
    @PreAuthorize(value="@ss.hasPermission('system:menu:update')")
    public Result<?> updateMenu(@Valid @RequestBody MenuUpdateReqVO reqVO) {
        this.menuService.update(MenuConvert.INSTANCE.convert(reqVO));
        return Result.getSuccessful();
    }

    @DeleteMapping(value={"/{id}"})
    @PreAuthorize(value="@ss.hasPermission('system:menu:remove')")
    public Result<?> deleteMenu(@PathVariable(value="id") Long id) {
        this.menuService.remove(id);
        return Result.getSuccessful();
    }

    @GetMapping(value={"/{id}"})
    @PreAuthorize(value="@ss.hasPermission('system:menu:update')")
    public Result<MenuRespVO> getMenu(@PathVariable(value="id") Long id) {
        return Result.getSuccessful((Object)MenuConvert.INSTANCE.convert(this.menuService.get(id)));
    }

    @GetMapping(value={"/simple"})
    public Result<List<MenuSimpleRespVO>> getSimpleMenus() {
        MenuQueryReqVO reqVO = new MenuQueryReqVO();
        reqVO.setStatus(CommonStatus.enabled.status());
        List<Menu> list = this.menuService.get(reqVO);
        list.sort(Comparator.comparing(Menu::getSort));
        return Result.getSuccessful(MenuConvert.INSTANCE.convert0(list));
    }
}

