/*
 * Decompiled with CFR 0.152.
 */
package xyz.migoo.framework.infra.controller.sys.permission.role;

import jakarta.annotation.Resource;
import jakarta.validation.Valid;
import java.util.List;
import java.util.Set;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import xyz.migoo.framework.common.enums.CommonStatus;
import xyz.migoo.framework.common.enums.NumberConstants;
import xyz.migoo.framework.common.pojo.PageResult;
import xyz.migoo.framework.common.pojo.Result;
import xyz.migoo.framework.infra.controller.sys.permission.role.vo.PermissionAssignRoleMenuReqVO;
import xyz.migoo.framework.infra.controller.sys.permission.role.vo.RoleAddReqVO;
import xyz.migoo.framework.infra.controller.sys.permission.role.vo.RoleQueryReqVO;
import xyz.migoo.framework.infra.controller.sys.permission.role.vo.RoleRespVO;
import xyz.migoo.framework.infra.controller.sys.permission.role.vo.RoleSimpleRespVO;
import xyz.migoo.framework.infra.controller.sys.permission.role.vo.RoleUpdateReqVO;
import xyz.migoo.framework.infra.convert.sys.RoleConvert;
import xyz.migoo.framework.infra.dal.dataobject.sys.Role;
import xyz.migoo.framework.infra.service.sys.permission.PermissionService;
import xyz.migoo.framework.infra.service.sys.permission.RoleService;

@RestController
@RequestMapping(value={"/role"})
public class RoleController {
    @Resource
    private RoleService roleService;
    @Resource
    private PermissionService permissionService;

    @GetMapping
    @PreAuthorize(value="@ss.hasPermission('system:role:query')")
    public Result<PageResult<RoleRespVO>> getRolePage(RoleQueryReqVO req) {
        return Result.getSuccessful(RoleConvert.INSTANCE.convert(this.roleService.getPage(req)));
    }

    @PostMapping
    @PreAuthorize(value="@ss.hasPermission('system:role:add')")
    public Result<?> addRole(@RequestBody RoleAddReqVO reqVO) {
        this.roleService.verify(reqVO.getCode(), reqVO.getName(), null);
        this.roleService.add(RoleConvert.INSTANCE.convert(reqVO));
        return Result.getSuccessful();
    }

    @PutMapping
    @PreAuthorize(value="@ss.hasPermission('system:role:update')")
    public Result<?> updateRole(@RequestBody RoleUpdateReqVO reqVO) {
        this.roleService.verify(reqVO.getCode(), reqVO.getName(), reqVO.getId());
        this.roleService.update(RoleConvert.INSTANCE.convert(reqVO));
        return Result.getSuccessful();
    }

    @GetMapping(value={"/{id}"})
    @PreAuthorize(value="@ss.hasPermission('system:role:update')")
    public Result<?> getRole(@PathVariable(value="id") Long id) {
        return Result.getSuccessful((Object)RoleConvert.INSTANCE.convert(this.roleService.get(id)));
    }

    @DeleteMapping(value={"/{id}"})
    @PreAuthorize(value="@ss.hasPermission('system:role:remove')")
    public Result<?> removeRole(@PathVariable(value="id") Long id) {
        this.roleService.remove(id);
        return Result.getSuccessful();
    }

    @GetMapping(value={"/simple"})
    public Result<List<RoleSimpleRespVO>> getSimpleMenus() {
        List<Role> list = this.roleService.getList(CommonStatus.enabled.status()).stream().filter(role -> (Long)role.getId() > (long)NumberConstants.N_1.intValue()).toList();
        return Result.getSuccessful(RoleConvert.INSTANCE.convert(list));
    }

    @GetMapping(value={"/{roleId}/menu"})
    @PreAuthorize(value="@ss.hasPermission('system:permission:assign-role-menu')")
    public Result<Set<Long>> getRoleMenus(@PathVariable(value="roleId") Long roleId) {
        return Result.getSuccessful(this.permissionService.getRoleMenuIds(roleId));
    }

    @PostMapping(value={"/{roleId}/menu"})
    @PreAuthorize(value="@ss.hasPermission('system:permission:assign-role-menu')")
    public Result<?> assignRoleMenus(@PathVariable(value="roleId") Long roleId, @Valid @RequestBody PermissionAssignRoleMenuReqVO reqVO) {
        reqVO.setRoleId(roleId);
        this.permissionService.assignRoleMenu(reqVO.getRoleId(), reqVO.getMenuIds());
        return Result.getSuccessful((Object)true);
    }
}

