/*
 * Decompiled with CFR 0.152.
 */
package xyz.migoo.framework.infra.controller.sys.post;

import jakarta.annotation.Resource;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import xyz.migoo.framework.common.enums.CommonStatus;
import xyz.migoo.framework.common.pojo.PageResult;
import xyz.migoo.framework.common.pojo.Result;
import xyz.migoo.framework.common.pojo.SimpleData;
import xyz.migoo.framework.infra.controller.sys.post.vo.PostAddReqVO;
import xyz.migoo.framework.infra.controller.sys.post.vo.PostBaseVO;
import xyz.migoo.framework.infra.controller.sys.post.vo.PostQueryReqVO;
import xyz.migoo.framework.infra.controller.sys.post.vo.PostRespVO;
import xyz.migoo.framework.infra.controller.sys.post.vo.PostUpdateReqVO;
import xyz.migoo.framework.infra.convert.sys.PostConvert;
import xyz.migoo.framework.infra.dal.dataobject.sys.Post;
import xyz.migoo.framework.infra.service.sys.post.PostService;

@RestController
@RequestMapping(value={"/post"})
public class PostController {
    @Resource
    private PostService postService;

    @GetMapping
    @PreAuthorize(value="@ss.hasPermission('system:post:query')")
    public Result<PageResult<PostRespVO>> getPage(PostQueryReqVO req) {
        PageResult<PostRespVO> result = PostConvert.INSTANCE.convert(this.postService.getPage(req));
        result.getList().sort(Comparator.comparing(PostBaseVO::getSort));
        return Result.getSuccessful(result);
    }

    @PostMapping
    @PreAuthorize(value="@ss.hasPermission('system:post:add')")
    public Result<?> add(@RequestBody PostAddReqVO req) {
        this.postService.verify(req.getCode(), req.getName(), null);
        this.postService.add(PostConvert.INSTANCE.convert(req));
        return Result.getSuccessful();
    }

    @PutMapping
    @PreAuthorize(value="@ss.hasPermission('system:post:update')")
    public Result<?> update(@RequestBody PostUpdateReqVO req) {
        this.postService.verify(req.getCode(), req.getName(), req.getId());
        this.postService.update(PostConvert.INSTANCE.convert(req));
        return Result.getSuccessful();
    }

    @GetMapping(value={"/{id}"})
    @PreAuthorize(value="@ss.hasPermission('system:post:update')")
    public Result<?> get(@PathVariable(value="id") Long id) {
        return Result.getSuccessful((Object)PostConvert.INSTANCE.convert(this.postService.get(id)));
    }

    @DeleteMapping(value={"/{id}"})
    @PreAuthorize(value="@ss.hasPermission('system:post:remove')")
    public Result<?> remove(@PathVariable(value="id") Long id) {
        this.postService.remove(id);
        return Result.getSuccessful();
    }

    @GetMapping(value={"/simple"})
    public Result<List<SimpleData>> getSimplePosts() {
        List<Post> list = this.postService.getList(null, Collections.singleton(CommonStatus.enabled.status()));
        list.sort(Comparator.comparing(Post::getSort));
        return Result.getSuccessful(PostConvert.INSTANCE.convert(list));
    }
}

