/*
 * Decompiled with CFR 0.152.
 */
package xyz.migoo.framework.infra.controller.sys.user;

import cn.hutool.core.collection.CollUtil;
import com.google.common.collect.Lists;
import jakarta.annotation.Resource;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import xyz.migoo.framework.common.enums.CommonStatus;
import xyz.migoo.framework.common.enums.NumberConstants;
import xyz.migoo.framework.common.pojo.PageResult;
import xyz.migoo.framework.common.pojo.Result;
import xyz.migoo.framework.common.pojo.SimpleData;
import xyz.migoo.framework.common.util.collection.CollectionUtils;
import xyz.migoo.framework.infra.controller.sys.user.vo.PermissionAssignUserRoleReqVO;
import xyz.migoo.framework.infra.controller.sys.user.vo.UserAddReqVO;
import xyz.migoo.framework.infra.controller.sys.user.vo.UserPageItemRespVO;
import xyz.migoo.framework.infra.controller.sys.user.vo.UserPasswordReqVO;
import xyz.migoo.framework.infra.controller.sys.user.vo.UserQueryReqVO;
import xyz.migoo.framework.infra.controller.sys.user.vo.UserUpdateReqVO;
import xyz.migoo.framework.infra.convert.sys.UserConvert;
import xyz.migoo.framework.infra.dal.dataobject.sys.Dept;
import xyz.migoo.framework.infra.dal.dataobject.sys.User;
import xyz.migoo.framework.infra.service.sys.dept.DeptService;
import xyz.migoo.framework.infra.service.sys.permission.PermissionService;
import xyz.migoo.framework.infra.service.sys.user.UserService;
import xyz.migoo.framework.security.core.LoginUser;
import xyz.migoo.framework.security.core.annotation.Authenticator;
import xyz.migoo.framework.security.core.annotation.CurrentUser;

@RestController
@RequestMapping(value={"/user"})
public class UserController {
    @Resource
    private UserService userService;
    @Resource
    private DeptService deptService;
    @Resource
    private PermissionService permissionService;

    @GetMapping
    @PreAuthorize(value="@ss.hasPermission('system:user:query')")
    public Result<PageResult<UserPageItemRespVO>> getUserPage(@CurrentUser LoginUser currentUser, UserQueryReqVO req) {
        PageResult<User> pageResult = this.userService.getPage(req);
        if (CollUtil.isEmpty((Collection)pageResult.getList())) {
            return Result.getSuccessful((Object)PageResult.empty());
        }
        List deptIds = CollectionUtils.convertList((Collection)pageResult.getList(), User::getDeptId);
        Map<Long, Dept> deptMap = this.deptService.getDeptMap(deptIds);
        ArrayList userList = Lists.newArrayListWithCapacity((int)pageResult.getList().size());
        for (User user : pageResult.getList()) {
            if (!currentUser.getId().equals(NumberConstants.N_1.longValue()) && ((Long)user.getId()).equals(NumberConstants.N_1.longValue())) continue;
            UserPageItemRespVO respVO = UserConvert.INSTANCE.convert(user);
            respVO.setDept(UserConvert.INSTANCE.convert(deptMap.get(user.getDeptId())));
            userList.add(respVO);
        }
        return Result.getSuccessful((Object)new PageResult((List)userList, pageResult.getTotal()));
    }

    @PostMapping
    @PreAuthorize(value="@ss.hasPermission('system:user:add')")
    public Result<?> addUser(@Valid @RequestBody UserAddReqVO user) {
        this.userService.verify(user.getUsername());
        this.userService.add(UserConvert.INSTANCE.convert(user));
        return Result.getSuccessful();
    }

    @PutMapping
    @PreAuthorize(value="@ss.hasPermission('system:user:update')")
    public Result<?> updateUser(@Valid @RequestBody UserUpdateReqVO user) {
        this.userService.update(UserConvert.INSTANCE.convert(user));
        return Result.getSuccessful();
    }

    @GetMapping(value={"/{id}"})
    @PreAuthorize(value="@ss.hasPermission('system:user:update')")
    public Result<?> getUser(@PathVariable(value="id") Long id) {
        return Result.getSuccessful((Object)UserConvert.INSTANCE.convert(this.userService.get(id)));
    }

    @DeleteMapping(value={"/{id}"})
    @PreAuthorize(value="@ss.hasPermission('system:user:remove')")
    public Result<?> removeUser(@PathVariable(value="id") Long id) {
        this.userService.remove(id);
        return Result.getSuccessful();
    }

    @GetMapping(value={"/simple"})
    public Result<List<SimpleData>> getSimple() {
        List<User> list = this.userService.get(CommonStatus.enabled.status());
        return Result.getSuccessful(UserConvert.INSTANCE.convert(list));
    }

    @GetMapping(value={"/{userId}/role"})
    public Result<Set<Long>> getUserRoles(@PathVariable(value="userId") Long userId) {
        return Result.getSuccessful(this.permissionService.getUserRoleIs(userId));
    }

    @PostMapping(value={"/role"})
    @PreAuthorize(value="@ss.hasPermission('system:permission:assign-user-role')")
    public Result<?> assignUserRole(@Valid @RequestBody PermissionAssignUserRoleReqVO reqVO) {
        this.permissionService.assignUserRole(reqVO.getUserId(), reqVO.getRoleIds());
        return Result.getSuccessful((Object)true);
    }

    @PostMapping(value={"/password"})
    @PreAuthorize(value="@ss.hasPermission('system:user:reset-password')")
    public Result<?> resetPassword(@RequestBody @Valid UserPasswordReqVO reqVO) {
        this.userService.update(UserConvert.INSTANCE.convert(reqVO));
        return Result.getSuccessful((Object)true);
    }

    @PostMapping(value={"/{no}/authenticator"})
    @Authenticator
    @PreAuthorize(value="@ss.hasPermission('member:merchant:reset-authenticator')")
    public Result<Boolean> resetAuthenticator(@PathVariable(value="no") Long no) {
        this.userService.resetAuthenticator(no);
        return Result.getSuccessful((Object)true);
    }
}

