/*
 * Decompiled with CFR 0.152.
 */
package xyz.migoo.framework.infra.convert;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.mapstruct.Mapper;
import org.mapstruct.factory.Mappers;
import org.slf4j.LoggerFactory;
import xyz.migoo.framework.common.enums.CommonStatus;
import xyz.migoo.framework.common.util.collection.CollectionUtils;
import xyz.migoo.framework.infra.controller.login.vo.AuthMenuRespVO;
import xyz.migoo.framework.infra.controller.login.vo.AuthUserInfoRespVO;
import xyz.migoo.framework.infra.dal.dataobject.sys.Menu;
import xyz.migoo.framework.infra.enums.MenuIdEnum;
import xyz.migoo.framework.security.core.BaseUser;
import xyz.migoo.framework.security.core.LoginUser;

@Mapper
public interface AuthConvert {
    public static final AuthConvert INSTANCE = (AuthConvert)Mappers.getMapper(AuthConvert.class);

    default public LoginUser convert(BaseUser<Long> user) {
        return new LoginUser().setRequiredBindAuthenticator(CommonStatus.isDisabled((int)user.getBindAuthenticator())).setRequiredVerifyAuthenticator(CommonStatus.isEnabled((int)user.getRequiredVerifyAuthenticator())).setId((Long)user.getId()).setName(user.getName()).setUpdateTime(new Date()).setEnabled(Boolean.valueOf(CommonStatus.isEnabled((int)user.getStatus()))).setUsername(user.getUsername()).setPassword(user.getPassword()).setSecurityCode(user.getSecretKey());
    }

    default public AuthUserInfoRespVO convert(BaseUser<Long> user, Set<String> permissions) {
        return this.convert1(user).setPermissions(permissions);
    }

    public AuthUserInfoRespVO convert1(BaseUser<Long> var1);

    default public AuthUserInfoRespVO convert(BaseUser<Long> user, List<Menu> menus) {
        return this.convert1(user).setRequiredBindAuthenticator(CommonStatus.isDisabled((int)user.getBindAuthenticator())).setPermissions(CollectionUtils.convertSet(menus, Menu::getPermission));
    }

    public AuthMenuRespVO convert(Menu var1);

    default public List<AuthMenuRespVO> convert(List<Menu> menuList) {
        menuList.sort(Comparator.comparing(Menu::getSort));
        LinkedHashMap treeNodeMap = new LinkedHashMap();
        menuList.forEach(menu -> treeNodeMap.put((Long)menu.getId(), this.convert((Menu)((Object)menu))));
        treeNodeMap.values().stream().filter(node -> !node.getParentId().equals(MenuIdEnum.ROOT.getId())).forEach(childNode -> {
            AuthMenuRespVO parentNode = (AuthMenuRespVO)treeNodeMap.get(childNode.getParentId());
            if (parentNode == null) {
                LoggerFactory.getLogger(this.getClass()).error("[buildRouterTree][resource({}) \u627e\u4e0d\u5230\u7236\u8d44\u6e90({})]", (Object)childNode.getId(), (Object)childNode.getParentId());
                return;
            }
            if (parentNode.getChildren() == null) {
                parentNode.setChildren(new ArrayList<AuthMenuRespVO>());
            }
            parentNode.getChildren().add((AuthMenuRespVO)childNode);
        });
        return CollectionUtils.filterList(treeNodeMap.values(), node -> MenuIdEnum.ROOT.getId().equals(node.getParentId()));
    }
}

