/*
 * Decompiled with CFR 0.152.
 */
package xyz.migoo.framework.infra.convert.sys;

import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import xyz.migoo.framework.common.pojo.PageResult;
import xyz.migoo.framework.common.pojo.SimpleData;
import xyz.migoo.framework.infra.controller.sys.post.vo.PostAddReqVO;
import xyz.migoo.framework.infra.controller.sys.post.vo.PostRespVO;
import xyz.migoo.framework.infra.controller.sys.post.vo.PostUpdateReqVO;
import xyz.migoo.framework.infra.convert.sys.PostConvert;
import xyz.migoo.framework.infra.dal.dataobject.sys.Post;

public class PostConvertImpl
implements PostConvert {
    @Override
    public PageResult<PostRespVO> convert(PageResult<Post> page) {
        if (page == null) {
            return null;
        }
        PageResult pageResult = new PageResult();
        pageResult.setList(this.postListToPostRespVOList(page.getList()));
        pageResult.setTotal(page.getTotal());
        return pageResult;
    }

    @Override
    public Post convert(PostAddReqVO req) {
        if (req == null) {
            return null;
        }
        Post post = new Post();
        post.setName(req.getName());
        post.setCode(req.getCode());
        post.setSort(req.getSort());
        post.setRemark(req.getRemark());
        return post;
    }

    @Override
    public Post convert(PostUpdateReqVO req) {
        if (req == null) {
            return null;
        }
        Post post = new Post();
        post.setId(req.getId());
        post.setName(req.getName());
        post.setCode(req.getCode());
        post.setSort(req.getSort());
        post.setStatus(req.getStatus());
        post.setRemark(req.getRemark());
        return post;
    }

    @Override
    public List<SimpleData> convert(List<Post> list) {
        if (list == null) {
            return null;
        }
        ArrayList<SimpleData> list1 = new ArrayList<SimpleData>(list.size());
        for (Post post : list) {
            list1.add(this.convert1(post));
        }
        return list1;
    }

    @Override
    public PostRespVO convert(Post post) {
        if (post == null) {
            return null;
        }
        PostRespVO postRespVO = new PostRespVO();
        postRespVO.setName(post.getName());
        postRespVO.setCode(post.getCode());
        postRespVO.setSort(post.getSort());
        postRespVO.setRemark(post.getRemark());
        postRespVO.setId((Long)post.getId());
        postRespVO.setStatus(post.getStatus());
        if (post.getCreateTime() != null) {
            postRespVO.setCreateTime(Date.from(post.getCreateTime().toInstant(ZoneOffset.UTC)));
        }
        return postRespVO;
    }

    protected List<PostRespVO> postListToPostRespVOList(List<Post> list) {
        if (list == null) {
            return null;
        }
        ArrayList<PostRespVO> list1 = new ArrayList<PostRespVO>(list.size());
        for (Post post : list) {
            list1.add(this.convert(post));
        }
        return list1;
    }
}

