/*
 * Decompiled with CFR 0.152.
 */
package xyz.migoo.framework.infra.convert.sys;

import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import xyz.migoo.framework.common.pojo.PageResult;
import xyz.migoo.framework.infra.controller.sys.permission.role.vo.RoleAddReqVO;
import xyz.migoo.framework.infra.controller.sys.permission.role.vo.RoleRespVO;
import xyz.migoo.framework.infra.controller.sys.permission.role.vo.RoleSimpleRespVO;
import xyz.migoo.framework.infra.controller.sys.permission.role.vo.RoleUpdateReqVO;
import xyz.migoo.framework.infra.convert.sys.RoleConvert;
import xyz.migoo.framework.infra.dal.dataobject.sys.Role;

public class RoleConvertImpl
implements RoleConvert {
    @Override
    public Role convert(RoleAddReqVO reqVO) {
        if (reqVO == null) {
            return null;
        }
        Role role = new Role();
        role.setName(reqVO.getName());
        role.setCode(reqVO.getCode());
        role.setSort(reqVO.getSort());
        role.setRemark(reqVO.getRemark());
        return role;
    }

    @Override
    public Role convert(RoleUpdateReqVO reqVO) {
        if (reqVO == null) {
            return null;
        }
        Role role = new Role();
        role.setId(reqVO.getId());
        role.setName(reqVO.getName());
        role.setCode(reqVO.getCode());
        role.setSort(reqVO.getSort());
        role.setStatus(reqVO.getStatus());
        role.setRemark(reqVO.getRemark());
        return role;
    }

    @Override
    public RoleRespVO convert(Role role) {
        if (role == null) {
            return null;
        }
        RoleRespVO roleRespVO = new RoleRespVO();
        roleRespVO.setName(role.getName());
        roleRespVO.setCode(role.getCode());
        roleRespVO.setSort(role.getSort());
        roleRespVO.setRemark(role.getRemark());
        roleRespVO.setId((Long)role.getId());
        roleRespVO.setStatus(role.getStatus());
        roleRespVO.setType(role.getType());
        if (role.getCreateTime() != null) {
            roleRespVO.setCreateTime(Date.from(role.getCreateTime().toInstant(ZoneOffset.UTC)));
        }
        return roleRespVO;
    }

    @Override
    public List<RoleSimpleRespVO> convert(List<Role> list) {
        if (list == null) {
            return null;
        }
        ArrayList<RoleSimpleRespVO> list1 = new ArrayList<RoleSimpleRespVO>(list.size());
        for (Role role : list) {
            list1.add(this.roleToRoleSimpleRespVO(role));
        }
        return list1;
    }

    @Override
    public PageResult<RoleRespVO> convert(PageResult<Role> page) {
        if (page == null) {
            return null;
        }
        PageResult pageResult = new PageResult();
        pageResult.setList(this.roleListToRoleRespVOList(page.getList()));
        pageResult.setTotal(page.getTotal());
        return pageResult;
    }

    protected RoleSimpleRespVO roleToRoleSimpleRespVO(Role role) {
        if (role == null) {
            return null;
        }
        RoleSimpleRespVO roleSimpleRespVO = new RoleSimpleRespVO();
        roleSimpleRespVO.setId((Long)role.getId());
        roleSimpleRespVO.setName(role.getName());
        return roleSimpleRespVO;
    }

    protected List<RoleRespVO> roleListToRoleRespVOList(List<Role> list) {
        if (list == null) {
            return null;
        }
        ArrayList<RoleRespVO> list1 = new ArrayList<RoleRespVO>(list.size());
        for (Role role : list) {
            list1.add(this.convert(role));
        }
        return list1;
    }
}

