/*
 * Decompiled with CFR 0.152.
 */
package xyz.migoo.framework.infra.dal.mapper.sys;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Select;
import xyz.migoo.framework.infra.dal.dataobject.sys.RoleMenu;
import xyz.migoo.framework.mybatis.core.BaseMapperX;
import xyz.migoo.framework.mybatis.core.LambdaQueryWrapperX;

@Mapper
public interface RoleMenuMapper
extends BaseMapperX<RoleMenu> {
    default public List<RoleMenu> selectListByRoleId(Long roleId) {
        return this.selectList((Wrapper)new LambdaQueryWrapperX().eq(RoleMenu::getRoleId, (Object)roleId));
    }

    default public void insertList(Long roleId, Collection<Long> menuIds) {
        List<RoleMenu> list = menuIds.stream().map(menuId -> {
            RoleMenu entity = new RoleMenu();
            entity.setRoleId(roleId);
            entity.setMenuId((Long)menuId);
            return entity;
        }).toList();
        list.forEach(arg_0 -> ((RoleMenuMapper)this).insert(arg_0));
    }

    default public void deleteListByRoleIdAndMenuIds(Long roleId, Collection<Long> menuIds) {
        this.delete((Wrapper)new LambdaQueryWrapperX().eq(RoleMenu::getRoleId, (Object)roleId).in(RoleMenu::getMenuId, menuIds));
    }

    default public void deleteListByMenuId(Long menuId) {
        this.delete((Wrapper)new LambdaQueryWrapperX().eq(RoleMenu::getMenuId, (Object)menuId));
    }

    default public void deleteListByRoleId(Long roleId) {
        this.delete((Wrapper)new LambdaQueryWrapperX().eq(RoleMenu::getRoleId, (Object)roleId));
    }

    @Select(value={"SELECT id FROM sys_role_menu WHERE update_time > #{maxUpdateTime} LIMIT 1"})
    public Long selectExistsByUpdateTimeAfter(LocalDateTime var1);
}

